/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;

public class GlobalKeySetTask<K, V>
implements DistributedCallable<K, V, Set<K>>,
Serializable {
    private Cache<K, V> cache;

    @Override
    public Set<K> call() throws Exception {
        return new HashSet(this.cache.keySet());
    }

    @Override
    public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
        this.cache = cache;
    }

    public static <K, V> Set<K> getGlobalKeySet(Cache<K, V> cache) throws InterruptedException, ExecutionException {
        if (cache.getCacheConfiguration().clustering().cacheMode().isDistributed()) {
            DefaultExecutorService des = new DefaultExecutorService(cache);
            List fk = des.submitEverywhere(new GlobalKeySetTask<K, V>());
            HashSet allKeys = new HashSet();
            for (Future f : fk) {
                allKeys.addAll((Collection)f.get());
            }
            return allKeys;
        }
        return new HashSet(cache.keySet());
    }
}

