/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyAwareSyncConsistentHashFactory
extends SyncConsistentHashFactory {
    @Override
    protected Builder createBuilder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        return new Builder(hashFunction, numOwners, numSegments, members, capacityFactors);
    }

    public static class Externalizer
    extends AbstractExternalizer<TopologyAwareSyncConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, TopologyAwareSyncConsistentHashFactory chf) {
        }

        @Override
        public TopologyAwareSyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new TopologyAwareSyncConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 95;
        }

        @Override
        public Set<Class<? extends TopologyAwareSyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(TopologyAwareSyncConsistentHashFactory.class);
        }
    }

    protected static class Builder
    extends SyncConsistentHashFactory.Builder {
        protected final TopologyInfo topologyInfo;
        protected TopologyLevel currentLevel = TopologyLevel.SITE;

        protected Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            super(hashFunction, numOwners, numSegments, members, capacityFactors);
            this.topologyInfo = new TopologyInfo(members, capacityFactors);
        }

        @Override
        protected void copyOwners() {
            this.copyOwnersForLevel(TopologyLevel.SITE);
            this.copyOwnersForLevel(TopologyLevel.RACK);
            this.copyOwnersForLevel(TopologyLevel.MACHINE);
            this.copyOwnersForLevel(TopologyLevel.NODE);
        }

        private void copyOwnersForLevel(TopologyLevel topologyLevel) {
            this.currentLevel = topologyLevel;
            this.ignoreMaxSegments = false;
            super.doCopyOwners();
            this.ignoreMaxSegments = true;
            super.doCopyOwners();
        }

        @Override
        protected void addOwner(int segment, Address candidate) {
            List owners = this.segmentOwners[segment];
            if (owners.size() < this.actualNumOwners && !this.locationAlreadyAdded(candidate, owners, this.currentLevel)) {
                if (!this.ignoreMaxSegments) {
                    if (owners.isEmpty()) {
                        long maxSegments = Math.round(this.computeExpectedSegmentsForNode(candidate, 1) * (double)1.2f);
                        if ((long)this.stats.getPrimaryOwned(candidate) < maxSegments) {
                            this.addOwnerNoCheck(segment, candidate);
                        }
                    } else {
                        long maxSegments = Math.round(this.computeExpectedSegmentsForNode(candidate, this.actualNumOwners) * (double)1.1f);
                        if ((long)this.stats.getOwned(candidate) < maxSegments) {
                            this.addOwnerNoCheck(segment, candidate);
                        }
                    }
                } else if (!((Float)this.capacityFactors.get(candidate)).equals(Float.valueOf(0.0f))) {
                    this.addOwnerNoCheck(segment, candidate);
                }
            }
        }

        @Override
        protected boolean canAddOwners(List<Address> owners) {
            return owners.size() < this.topologyInfo.getDistinctLocationsCount(this.currentLevel, this.actualNumOwners);
        }

        @Override
        protected double computeExpectedSegmentsForNode(Address node, int numCopies) {
            return this.topologyInfo.computeExpectedSegments(this.numSegments, numCopies, node);
        }

        private boolean locationAlreadyAdded(Address candidate, List<Address> owners, TopologyLevel level) {
            TopologyAwareAddress topologyAwareCandidate = (TopologyAwareAddress)candidate;
            boolean locationAlreadyAdded = false;
            for (Address owner : owners) {
                TopologyAwareAddress topologyAwareOwner = (TopologyAwareAddress)owner;
                switch (level) {
                    case SITE: {
                        locationAlreadyAdded = topologyAwareCandidate.isSameSite(topologyAwareOwner);
                        break;
                    }
                    case RACK: {
                        locationAlreadyAdded = topologyAwareCandidate.isSameRack(topologyAwareOwner);
                        break;
                    }
                    case MACHINE: {
                        locationAlreadyAdded = topologyAwareCandidate.isSameMachine(topologyAwareOwner);
                        break;
                    }
                    case NODE: {
                        locationAlreadyAdded = owner.equals(candidate);
                    }
                }
                if (!locationAlreadyAdded) continue;
                break;
            }
            return locationAlreadyAdded;
        }
    }
}

