/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.BaseStateTransferInterceptor;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderStateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderStateTransferInterceptor.class);

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.localPrepare(ctx, command);
        }
        return this.remotePrepare(ctx, command);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private Object remotePrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        int topologyId = this.currentTopologyId();
        ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
        if (log.isTraceEnabled()) {
            log.tracef("Remote transaction received %s. Tx topology id is %s and current topology is is %s", (Object)ctx.getGlobalTransaction().globalId(), (Object)command.getTopologyId(), (Object)topologyId);
        }
        if (command.getTopologyId() < topologyId) {
            if (log.isDebugEnabled()) {
                log.debugf("Transaction %s delivered in new topology Id. Discard it because it should be retransmitted", (Object)ctx.getGlobalTransaction().globalId());
            }
            throw new RetryPrepareException();
        }
        if (command.getTopologyId() > topologyId) {
            throw new IllegalStateException("This should never happen");
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object localPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        boolean needsToPrepare = true;
        Object retVal = null;
        while (needsToPrepare) {
            try {
                command.setTopologyId(this.currentTopologyId());
                if (log.isTraceEnabled()) {
                    log.tracef("Local transaction received %s. setting topology Id to %s", (Object)command.getGlobalTransaction().globalId(), (Object)command.getTopologyId());
                }
                retVal = this.invokeNextInterceptor(ctx, command);
                needsToPrepare = false;
            }
            catch (Throwable throwable) {
                needsToPrepare = this.needsToRePrepare(throwable);
                if (log.isDebugEnabled()) {
                    log.tracef("Exception caught while preparing transaction %s (cause = %s). Needs to retransmit? %s", (Object)command.getGlobalTransaction().globalId(), (Object)throwable.getCause(), (Object)needsToPrepare);
                }
                if (!needsToPrepare) {
                    throw throwable;
                }
                this.logRetry(command);
            }
        }
        return retVal;
    }

    private boolean needsToRePrepare(Throwable throwable) {
        return throwable instanceof RemoteException && throwable.getCause() instanceof RetryPrepareException;
    }
}

