/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile int lookedUpEntriesTopology = Integer.MAX_VALUE;
    private volatile TotalOrderRemoteTransactionState transactionState;
    private final Object transactionStateLock = new Object();

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        super(tx, topologyId, keyEquivalence, txCreationTime);
        this.modifications = modifications == null || modifications.length == 0 ? InfinispanCollections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = CollectionFactory.makeMap(this.modifications.size(), keyEquivalence, AnyEquivalence.getInstance());
    }

    public RemoteTransaction(GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        super(tx, topologyId, keyEquivalence, txCreationTime);
        this.modifications = new LinkedList();
        this.lookedUpEntries = CollectionFactory.makeMap(2, keyEquivalence, AnyEquivalence.getInstance());
    }

    @Override
    public void setStateTransferFlag(Flag stateTransferFlag) {
        if (this.getStateTransferFlag() == null && stateTransferFlag == Flag.PUT_FOR_X_SITE_STATE_TRANSFER) {
            this.internalSetStateTransferFlag(stateTransferFlag);
        }
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.checkIfRolledBack();
        if (trace) {
            log.tracef("Adding key %s to tx %s", key, (Object)this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.checkIfRolledBack();
        if (trace) {
            log.tracef("Adding keys %s to tx %s", (Object)entries.keySet(), (Object)this.getGlobalTransaction());
        }
        this.lookedUpEntries.putAll(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = CollectionFactory.makeMap(this.lookedUpEntries, this.keyEquivalence, AnyEquivalence.getInstance());
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", lockedKeys=" + this.lockedKeys + ", backupKeyLocks=" + this.backupKeyLocks + ", lookedUpEntriesTopology=" + this.lookedUpEntriesTopology + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", tx=" + this.tx + ", state=" + this.transactionState + '}';
    }

    public void setLookedUpEntriesTopology(int lookedUpEntriesTopology) {
        this.lookedUpEntriesTopology = lookedUpEntriesTopology;
    }

    public int lookedUpEntriesTopology() {
        return this.lookedUpEntriesTopology;
    }

    private void checkIfRolledBack() {
        if (this.isMarkedForRollback()) {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is already rolled back");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TotalOrderRemoteTransactionState getTransactionState() {
        if (this.transactionState != null) {
            return this.transactionState;
        }
        Object object = this.transactionStateLock;
        synchronized (object) {
            if (this.transactionState == null) {
                this.transactionState = new TotalOrderRemoteTransactionState(this.getGlobalTransaction());
            }
            return this.transactionState;
        }
    }
}

