/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractTransactionBoundaryCommand
implements TransactionBoundaryCommand {
    private static final Log log = LogFactory.getLog(AbstractTransactionBoundaryCommand.class);
    private static boolean trace = log.isTraceEnabled();
    protected GlobalTransaction globalTx;
    protected final String cacheName;
    protected InterceptorChain invoker;
    protected InvocationContextFactory icf;
    protected TransactionTable txTable;
    private Address origin;
    private int topologyId = -1;

    public AbstractTransactionBoundaryCommand(String cacheName) {
        this.cacheName = cacheName;
    }

    public void init(InterceptorChain chain, InvocationContextFactory icf, TransactionTable txTable) {
        this.invoker = chain;
        this.icf = icf;
        this.txTable = txTable;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTx;
    }

    @Override
    public void markTransactionAsRemote(boolean isRemote) {
        this.globalTx.setRemote(isRemote);
    }

    protected Object invalidRemoteTxReturnValue() {
        return null;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (ctx != null) {
            throw new IllegalStateException("Expected null context!");
        }
        this.markGtxAsRemote();
        RemoteTransaction transaction = this.getRemoteTransaction();
        if (transaction == null) {
            if (trace) {
                log.tracef("Did not find a RemoteTransaction for %s", (Object)this.globalTx);
            }
            return this.invalidRemoteTxReturnValue();
        }
        this.visitRemoteTransaction(transaction);
        RemoteTxInvocationContext ctxt = this.icf.createRemoteTxInvocationContext(transaction, this.getOrigin());
        if (trace) {
            log.tracef("About to execute tx command %s", (Object)this);
        }
        return this.invoker.invoke(ctxt, this);
    }

    protected void visitRemoteTransaction(RemoteTransaction tx) {
    }

    protected RemoteTransaction getRemoteTransaction() {
        return this.txTable.getRemoteTransaction(this.globalTx);
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.globalTx};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.globalTx = (GlobalTransaction)args[0];
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionBoundaryCommand that = (AbstractTransactionBoundaryCommand)o;
        return this.globalTx.equals(that.globalTx);
    }

    public int hashCode() {
        return this.globalTx.hashCode();
    }

    public String toString() {
        return "gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + ", topologyId=" + this.topologyId + '}';
    }

    private void markGtxAsRemote() {
        this.globalTx.setRemote(true);
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public final boolean canBlock() {
        return true;
    }
}

