/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<TransportConfiguration> {
    private static final Log log = LogFactory.getLog(TransportConfigurationBuilder.class);
    public static final String DEFAULT_TRANSPORT = "org.infinispan.remoting.transport.jgroups.JGroupsTransport";
    private final ThreadPoolConfigurationBuilder transportThreadPool;
    private final ThreadPoolConfigurationBuilder remoteCommandThreadPool;
    @Deprecated
    private final ThreadPoolConfigurationBuilder totalOrderThreadPool;
    private final AttributeSet attributes = TransportConfiguration.attributeSet();

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.transportThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.remoteCommandThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.totalOrderThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).set(clusterName);
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.attributes.attribute(TransportConfiguration.MACHINE_ID).set(machineId);
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.attributes.attribute(TransportConfiguration.RACK_ID).set(rackId);
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.attributes.attribute(TransportConfiguration.SITE_ID).set(siteId);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.attributes.attribute(TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT).set(distributedSyncTimeout);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout, TimeUnit unit) {
        return this.distributedSyncTimeout(unit.toMillis(distributedSyncTimeout));
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.attributes.attribute(TransportConfiguration.TRANSPORT).set(transport);
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.attributes.attribute(TransportConfiguration.NODE_NAME).set(nodeName);
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(properties));
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set(new TypedProperties());
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = this.attributes.attribute(TransportConfiguration.PROPERTIES).get();
        properties.put(key, value);
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set(properties);
        return this;
    }

    public TransportConfigurationBuilder removeProperty(String key) {
        TypedProperties properties = this.attributes.attribute(TransportConfiguration.PROPERTIES).get();
        properties.remove(key);
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set(properties);
        return this;
    }

    public String getProperty(String key) {
        return String.valueOf(this.attributes.attribute(TransportConfiguration.PROPERTIES).get().get(key));
    }

    @Deprecated
    public TransportConfigurationBuilder strictPeerToPeer(Boolean ignored) {
        log.strictPeerToPeerDeprecated();
        return this;
    }

    public ThreadPoolConfigurationBuilder transportThreadPool() {
        return this.transportThreadPool;
    }

    public ThreadPoolConfigurationBuilder remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    @Deprecated
    public ThreadPoolConfigurationBuilder totalOrderThreadPool() {
        return this.totalOrderThreadPool;
    }

    @Override
    public void validate() {
        for (Builder builder : Arrays.asList(this.transportThreadPool, this.remoteCommandThreadPool, this.totalOrderThreadPool)) {
            builder.validate();
        }
        if (this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).get() == null) {
            throw new CacheConfigurationException("Transport clusterName cannot be null");
        }
    }

    @Override
    public TransportConfiguration create() {
        return new TransportConfiguration(this.attributes.protect(), this.transportThreadPool.create(), this.remoteCommandThreadPool.create(), this.totalOrderThreadPool.create());
    }

    public TransportConfigurationBuilder defaultTransport() {
        Transport transport = (Transport)Util.getInstance(DEFAULT_TRANSPORT, this.getGlobalConfig().getClassLoader());
        this.transport(transport);
        return this;
    }

    public TransportConfigurationBuilder read(TransportConfiguration template) {
        this.attributes.read(template.attributes());
        this.remoteCommandThreadPool.read(template.remoteCommandThreadPool());
        this.totalOrderThreadPool.read(template.totalOrderThreadPool());
        this.transportThreadPool.read(template.transportThreadPool());
        if (template.transport() != null) {
            Transport transport = (Transport)Util.getInstance(template.transport().getClass().getName(), template.transport().getClass().getClassLoader());
            this.transport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        return this.attributes.attribute(TransportConfiguration.TRANSPORT).get();
    }

    public String toString() {
        return "TransportConfigurationBuilder [transportThreadPool=" + this.transportThreadPool + ", remoteCommandThreadPool=" + this.remoteCommandThreadPool + ", totalOrderThreadPool=" + this.totalOrderThreadPool + ", attributes=" + this.attributes + "]";
    }
}

