/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class SyncConfiguration {
    public static final AttributeDefinition<Long> REPL_TIMEOUT = AttributeDefinition.builder("replTimeout", TimeUnit.SECONDS.toMillis(15L)).build();
    private final Attribute<Long> replTimeout;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SyncConfiguration.class.getSimpleName(), REPL_TIMEOUT);
    }

    SyncConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.replTimeout = attributes.attribute(REPL_TIMEOUT);
    }

    public long replTimeout() {
        return this.replTimeout.get();
    }

    public SyncConfiguration replTimeout(long l) {
        this.replTimeout.set(l);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "SyncConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncConfiguration other = (SyncConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

