/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.IdentityEquivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class TransactionTable
implements org.infinispan.transaction.TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final int CACHE_STOPPED_TOPOLOGY_ID = -1;
    private volatile int minTxTopologyId = -1;
    private volatile int currentTopologyId = -1;
    protected Configuration configuration;
    protected InvocationContextFactory icf;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    protected RpcManager rpcManager;
    protected CommandsFactory commandsFactory;
    protected ClusteringDependentLogic clusteringLogic;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private CompletedTransactionsInfo completedTransactionsInfo;
    private ScheduledExecutorService cleanupExecutor;
    private String cacheName;
    private TimeService timeService;
    private CacheManagerNotifier cacheManagerNotifier;
    protected PartitionHandlingManager partitionHandlingManager;
    private ScheduledExecutorService timeoutExecutor;
    private ConcurrentMap<Transaction, LocalTransaction> localTransactions;
    private ConcurrentMap<GlobalTransaction, LocalTransaction> globalToLocalTransactions;
    private ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions;
    private Lock minTopologyRecalculationLock;
    protected boolean clustered = false;
    protected volatile boolean running = false;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextFactory icf, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry, CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic, Cache cache, TimeService timeService, CacheManagerNotifier cacheManagerNotifier, PartitionHandlingManager partitionHandlingManager, @ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icf = icf;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.commandsFactory = commandsFactory;
        this.clusteringLogic = clusteringDependentLogic;
        this.cacheManagerNotifier = cacheManagerNotifier;
        this.cacheName = cache.getName();
        this.timeService = timeService;
        this.partitionHandlingManager = partitionHandlingManager;
        this.timeoutExecutor = timeoutExecutor;
        this.clustered = configuration.clustering().cacheMode().isClustered();
    }

    @Start(priority=9)
    public void start() {
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.localTransactions = CollectionFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel, new IdentityEquivalence(), AnyEquivalence.getInstance());
        this.globalToLocalTransactions = CollectionFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
        boolean transactional = this.configuration.transaction().transactionMode().isTransactional();
        if (this.clustered && transactional) {
            this.minTopologyRecalculationLock = new ReentrantLock();
            this.remoteTransactions = CollectionFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    String address = TransactionTable.this.rpcManager != null ? TransactionTable.this.rpcManager.getTransport().getAddress().toString() : "local";
                    Thread th = new Thread(r, "TxCleanupService," + TransactionTable.this.cacheName + "," + address);
                    th.setDaemon(true);
                    return th;
                }
            };
            this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(tf);
            this.notifier.addListener(this);
            this.cacheManagerNotifier.addListener(this);
            boolean totalOrder = this.configuration.transaction().transactionProtocol().isTotalOrder();
            if (!totalOrder) {
                this.completedTransactionsInfo = new CompletedTransactionsInfo();
                long interval = this.configuration.transaction().reaperWakeUpInterval();
                this.cleanupExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        TransactionTable.this.completedTransactionsInfo.cleanupCompletedTransactions();
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                this.cleanupExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        TransactionTable.this.cleanupTimedOutTransactions();
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            }
        }
        this.running = true;
    }

    @Override
    public GlobalTransaction getGlobalTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("Transaction must not be null.");
        }
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(transaction);
        return localTransaction != null ? localTransaction.getGlobalTransaction() : null;
    }

    @Override
    public Collection<GlobalTransaction> getLocalGlobalTransaction() {
        return Collections.unmodifiableCollection(this.globalToLocalTransactions.keySet());
    }

    @Override
    public Collection<GlobalTransaction> getRemoteGlobalTransaction() {
        return Collections.unmodifiableCollection(this.remoteTransactions.keySet());
    }

    @Stop
    private void stop() {
        this.running = false;
        this.cacheManagerNotifier.removeListener(this);
        if (this.cleanupExecutor != null) {
            this.cleanupExecutor.shutdownNow();
        }
        if (this.clustered) {
            this.notifier.removeListener(this);
            this.currentTopologyId = -1;
        }
        this.shutDownGracefully();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return InfinispanCollections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator, this.commandsFactory, this.rpcManager, this, this.clusteringLogic, this.configuration, this.partitionHandlingManager);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException(e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    public int getMinTopologyId() {
        return this.minTxTopologyId;
    }

    public void cleanupLeaverTransactions(List<Address> members) {
        if (this.remoteTransactions == null) {
            return;
        }
        if (trace) {
            log.tracef("Checking for transactions originated on leavers. Current cache members are %s, remote transactions: %d", (Object)members, (Object)this.remoteTransactions.size());
        }
        HashSet<Address> membersSet = new HashSet<Address>(members);
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            GlobalTransaction gt = (GlobalTransaction)e.getKey();
            if (trace) {
                log.tracef("Checking transaction %s", (Object)gt);
            }
            if (membersSet.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            if (trace) {
                log.tracef("No remote transactions pertain to originator(s) who have left the cluster.", new Object[0]);
            }
        } else {
            log.debugf("The originating node left the cluster for %d remote transactions", toKill.size());
            for (GlobalTransaction gtx : toKill) {
                if (this.partitionHandlingManager.canRollbackTransactionAfterOriginatorLeave(gtx)) {
                    log.debugf("Rolling back transaction %s because originator %s left the cluster", (Object)gtx, (Object)gtx.getAddress());
                    this.killTransaction(gtx);
                    continue;
                }
                log.debugf("Keeping transaction %s after the originator %s left the cluster.", (Object)gtx, (Object)gtx.getAddress());
            }
            if (trace) {
                log.tracef("Completed cleaning transactions originating on leavers. Remote transactions remaining: %d", this.remoteTransactions.size());
            }
        }
    }

    public void cleanupTimedOutTransactions() {
        if (trace) {
            log.tracef("About to cleanup remote transactions older than %d ms", this.configuration.transaction().completedTxTimeout());
        }
        long beginning = this.timeService.time();
        long cutoffCreationTime = beginning - TimeUnit.MILLISECONDS.toNanos(this.configuration.transaction().completedTxTimeout());
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            GlobalTransaction gtx = (GlobalTransaction)e.getKey();
            RemoteTransaction remoteTx = (RemoteTransaction)e.getValue();
            if (remoteTx == null) continue;
            if (trace) {
                log.tracef("Checking transaction %s", (Object)gtx);
            }
            if (remoteTx.getCreationTime() - cutoffCreationTime >= 0L) continue;
            long duration = this.timeService.timeDuration(remoteTx.getCreationTime(), beginning, TimeUnit.MILLISECONDS);
            log.remoteTransactionTimeout(gtx, duration);
            toKill.add(gtx);
        }
        for (GlobalTransaction gtx : toKill) {
            this.killTransaction(gtx);
        }
    }

    private void killTransaction(GlobalTransaction gtx) {
        RollbackCommand rc = new RollbackCommand(this.cacheName, gtx);
        rc.init(this.invoker, this.icf, this);
        try {
            rc.perform(null);
            if (trace) {
                log.tracef("Rollback of transaction %s complete.", (Object)gtx);
            }
        }
        catch (Throwable e) {
            log.unableToRollbackGlobalTx(gtx, e);
        }
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        if (trace) {
            log.tracef("Removed local transaction %s? %b", (Object)gtx, (Object)remove);
        }
    }

    public RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        return this.getOrCreateRemoteTransaction(globalTx, modifications, this.currentTopologyId);
    }

    private RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications, int topologyId) {
        RemoteTransaction remoteTransaction = (RemoteTransaction)this.remoteTransactions.get(globalTx);
        if (remoteTransaction != null) {
            return remoteTransaction;
        }
        if (!this.running) {
            throw log.cacheIsStopping(this.cacheName);
        }
        remoteTransaction = modifications == null ? this.txFactory.newRemoteTransaction(globalTx, topologyId) : this.txFactory.newRemoteTransaction(modifications, globalTx, topologyId);
        RemoteTransaction existing = this.remoteTransactions.putIfAbsent(globalTx, remoteTransaction);
        if (existing != null) {
            if (trace) {
                log.tracef("Remote transaction already registered: %s", (Object)existing);
            }
            return existing;
        }
        if (trace) {
            log.tracef("Created and registered remote transaction %s", (Object)remoteTransaction);
        }
        if (remoteTransaction.getTopologyId() < this.minTxTopologyId) {
            if (trace) {
                log.tracef("Changing minimum topology ID from %d to %d", this.minTxTopologyId, remoteTransaction.getTopologyId());
            }
            this.minTxTopologyId = remoteTransaction.getTopologyId();
        }
        return remoteTransaction;
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, boolean implicitTransaction) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            if (!this.running) {
                throw log.cacheIsStopping(this.cacheName);
            }
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            current = this.txFactory.newLocalTransaction(transaction, tx, implicitTransaction, this.currentTopologyId);
            if (trace) {
                log.tracef("Created a new local transaction: %s", (Object)current);
            }
            this.localTransactions.put(transaction, current);
            this.globalToLocalTransactions.put(current.getGlobalTransaction(), current);
            this.notifier.notifyTransactionRegistered(tx, true);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    protected final LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction localTx = (LocalTransaction)this.localTransactions.get(tx);
        if (localTx != null) {
            this.globalToLocalTransactions.remove(localTx.getGlobalTransaction());
            this.localTransactions.remove(tx);
            this.releaseResources(localTx);
        }
        return localTx;
    }

    private void releaseResources(CacheTransaction cacheTransaction) {
        if (cacheTransaction != null) {
            if (this.clustered) {
                this.recalculateMinTopologyIdIfNeeded(cacheTransaction);
            }
            if (trace) {
                log.tracef("Removed %s from transaction table.", (Object)cacheTransaction);
            }
            cacheTransaction.notifyOnTransactionFinished();
        }
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx, boolean onePc) {
        boolean optimisticWih1Pc;
        boolean bl = optimisticWih1Pc = onePc && this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
        if (Configurations.isSecondPhaseAsync(this.configuration) || this.configuration.transaction().transactionProtocol().isTotalOrder() || optimisticWih1Pc) {
            this.removeRemoteTransaction(gtx);
        }
    }

    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction removed = (RemoteTransaction)this.remoteTransactions.remove(txId);
        if (trace) {
            log.tracef("Removed remote transaction %s ? %s", (Object)txId, (Object)removed);
        }
        this.releaseResources(removed);
        return removed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(GlobalTransaction txId) {
        return (LocalTransaction)this.globalToLocalTransactions.get(txId);
    }

    public boolean containsLocalTx(GlobalTransaction globalTransaction) {
        return this.globalToLocalTransactions.containsKey(globalTransaction);
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    public Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinTopologyIdIfNeeded(CacheTransaction removedTransaction) {
        if (removedTransaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null!");
        }
        if (this.currentTopologyId != -1) {
            int removedTransactionTopologyId = removedTransaction.getTopologyId();
            if (removedTransactionTopologyId < this.minTxTopologyId) {
                if (trace) {
                    log.tracef("A transaction has a topology ID (%s) that is smaller than the smallest transaction topology ID (%s) this node knows about!  This can happen if a concurrent thread recalculates the minimum topology ID after the current transaction has been removed from the transaction table.", removedTransactionTopologyId, this.minTxTopologyId);
                }
            } else if (removedTransactionTopologyId == this.minTxTopologyId && removedTransactionTopologyId < this.currentTopologyId) {
                this.calculateMinTopologyId(removedTransactionTopologyId);
            }
        }
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        if (this.clustered && !tce.isPre()) {
            this.currentTopologyId = tce.getNewTopologyId();
            log.debugf("Topology changed, recalculating minTopologyId", new Object[0]);
            this.calculateMinTopologyId(-1);
        }
    }

    @ViewChanged
    public void onViewChange(final ViewChangedEvent e) {
        block2: {
            try {
                this.cleanupExecutor.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        TransactionTable.this.cleanupLeaverTransactions(e.getNewMembers());
                        return null;
                    }
                });
            }
            catch (RejectedExecutionException x) {
                if (this.cleanupExecutor.isShutdown()) break block2;
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="minTopologyRecalculationLock")
    private void calculateMinTopologyId(int idOfRemovedTransaction) {
        this.minTopologyRecalculationLock.lock();
        try {
            if (idOfRemovedTransaction == -1 || idOfRemovedTransaction == this.minTxTopologyId && idOfRemovedTransaction < this.currentTopologyId) {
                int topologyId;
                int minTopologyIdFound = this.currentTopologyId;
                for (CacheTransaction ct : this.localTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                for (CacheTransaction ct : this.remoteTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                if (minTopologyIdFound != this.minTxTopologyId) {
                    if (trace) {
                        log.tracef("Changing minimum topology ID from %s to %s", this.minTxTopologyId, minTopologyIdFound);
                    }
                    this.minTxTopologyId = minTopologyIdFound;
                } else if (trace) {
                    log.tracef("Minimum topology ID still is %s; nothing to change", minTopologyIdFound);
                }
            }
        }
        finally {
            this.minTopologyRecalculationLock.unlock();
        }
    }

    private void shutDownGracefully() {
        boolean localTxsOnGoing;
        if (log.isDebugEnabled()) {
            log.debugf("Wait for on-going transactions to finish for %s.", (Object)Util.prettyPrintTime(this.configuration.transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS));
        }
        long now = System.nanoTime();
        long failTime = now + TimeUnit.MILLISECONDS.toNanos(this.configuration.transaction().cacheStopTimeout());
        boolean bl = localTxsOnGoing = !this.localTransactions.isEmpty();
        while (localTxsOnGoing && System.nanoTime() - failTime < 0L) {
            try {
                Thread.sleep(30L);
                localTxsOnGoing = !this.localTransactions.isEmpty();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debugf("Interrupted waiting for %d on-going local transactions to finish.", this.localTransactions.size());
            }
        }
        if (this.remoteTransactions != null) {
            Future<?> remoteTxsFuture = this.timeoutExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean transactions = false;
                    Iterator iterator = TransactionTable.this.remoteTransactions.values().iterator();
                    while (iterator.hasNext()) {
                        RemoteTransaction tx;
                        RemoteTransaction remoteTransaction = tx = (RemoteTransaction)iterator.next();
                        synchronized (remoteTransaction) {
                            tx.markForRollback(true);
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        break;
                    }
                }
            });
            try {
                remoteTxsFuture.get(failTime - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted waiting for on-going remote transactional commands to finish.");
                remoteTxsFuture.cancel(true);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.debug("Exception while waiting for on-going remote transactional commands to finish", e);
            }
            catch (TimeoutException e) {
                remoteTxsFuture.cancel(true);
            }
        }
        if (!this.localTransactions.isEmpty() || this.remoteTransactionsCount() != 0) {
            log.unfinishedTransactionsRemain(this.localTransactions.size(), this.remoteTransactionsCount());
            if (trace) {
                log.tracef("Unfinished local transactions: %s", (Object)this.localTransactions.values().stream().map(tx -> tx.getGlobalTransaction().toString()).collect(Collectors.joining(", ", "[", "]")));
                log.tracef("Unfinished remote transactions: %s", this.remoteTransactions == null ? "none" : this.remoteTransactions.keySet());
            }
        } else {
            log.debug("All transactions terminated");
        }
    }

    private int remoteTransactionsCount() {
        return this.remoteTransactions == null ? 0 : this.remoteTransactions.size();
    }

    public void markTransactionCompleted(GlobalTransaction gtx, boolean successful) {
        if (this.completedTransactionsInfo != null) {
            this.completedTransactionsInfo.markTransactionCompleted(gtx, successful);
        }
    }

    public boolean isTransactionCompleted(GlobalTransaction gtx) {
        return this.completedTransactionsInfo != null && this.completedTransactionsInfo.isTransactionCompleted(gtx);
    }

    public CompletedTransactionStatus getCompletedTransactionStatus(GlobalTransaction gtx) {
        if (this.completedTransactionsInfo == null) {
            return CompletedTransactionStatus.NOT_COMPLETED;
        }
        return this.completedTransactionsInfo.getTransactionStatus(gtx);
    }

    private static class CompletedTransactionInfo {
        public final long timestamp;
        public final boolean successful;

        private CompletedTransactionInfo(long timestamp, boolean successful) {
            this.timestamp = timestamp;
            this.successful = successful;
        }
    }

    private class CompletedTransactionsInfo {
        final EquivalentConcurrentHashMapV8<GlobalTransaction, CompletedTransactionInfo> completedTransactions;
        final EquivalentConcurrentHashMapV8<Address, Long> nodeMaxPrunedTxIds = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        volatile long globalMaxPrunedTxId = -1L;

        public CompletedTransactionsInfo() {
            this.completedTransactions = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        }

        public void markTransactionCompleted(GlobalTransaction globalTx, boolean successful) {
            if (trace) {
                log.tracef("Marking transaction %s as completed", (Object)globalTx);
            }
            this.completedTransactions.put(globalTx, new CompletedTransactionInfo(TransactionTable.this.timeService.time(), successful));
        }

        public boolean isTransactionCompleted(GlobalTransaction gtx) {
            if (this.completedTransactions.containsKey(gtx)) {
                return true;
            }
            if (gtx.getId() > this.globalMaxPrunedTxId) {
                return false;
            }
            Long nodeMaxPrunedTxId = this.nodeMaxPrunedTxIds.get(gtx.getAddress());
            return nodeMaxPrunedTxId != null && gtx.getId() <= nodeMaxPrunedTxId;
        }

        public CompletedTransactionStatus getTransactionStatus(GlobalTransaction gtx) {
            CompletedTransactionInfo completedTx = this.completedTransactions.get(gtx);
            if (completedTx != null) {
                return completedTx.successful ? CompletedTransactionStatus.COMMITTED : CompletedTransactionStatus.ABORTED;
            }
            if (gtx.getId() > this.globalMaxPrunedTxId) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            Long nodeMaxPrunedTxId = this.nodeMaxPrunedTxIds.get(gtx.getAddress());
            if (nodeMaxPrunedTxId == null) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            if (gtx.getId() > nodeMaxPrunedTxId) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            return CompletedTransactionStatus.EXPIRED;
        }

        public void cleanupCompletedTransactions() {
            if (this.completedTransactions.isEmpty()) {
                return;
            }
            try {
                if (trace) {
                    log.tracef("About to cleanup completed transaction. Initial size is %d", this.completedTransactions.size());
                }
                long beginning = TransactionTable.this.timeService.time();
                long minCompleteTimestamp = TransactionTable.this.timeService.time() - TimeUnit.MILLISECONDS.toNanos(TransactionTable.this.configuration.transaction().completedTxTimeout());
                int removedEntries = 0;
                HashSet<Address> leavers = new HashSet<Address>();
                for (Map.Entry<Address, Long> entry : this.nodeMaxPrunedTxIds.entrySet()) {
                    if (TransactionTable.this.rpcManager.getMembers().contains(entry.getKey())) continue;
                    leavers.add(entry.getKey());
                }
                Iterator<Map.Entry<GlobalTransaction, CompletedTransactionInfo>> txIterator = this.completedTransactions.entrySet().iterator();
                while (txIterator.hasNext()) {
                    Map.Entry<GlobalTransaction, CompletedTransactionInfo> entry = txIterator.next();
                    CompletedTransactionInfo completedTransactionInfo = entry.getValue();
                    if (minCompleteTimestamp - completedTransactionInfo.timestamp > 0L) {
                        long txId = entry.getKey().getId();
                        Address address = entry.getKey().getAddress();
                        this.updateLastPrunedTxId(txId, address);
                        txIterator.remove();
                        ++removedEntries;
                        continue;
                    }
                    leavers.remove(entry.getKey().getAddress());
                }
                for (Address address : leavers) {
                    this.nodeMaxPrunedTxIds.remove(address);
                }
                long duration = TransactionTable.this.timeService.timeDuration(beginning, TimeUnit.MILLISECONDS);
                if (trace) {
                    log.tracef("Finished cleaning up completed transactions in %d millis, %d transactions were removed, current number of completed transactions is %d", (long)removedEntries, duration, (long)this.completedTransactions.size());
                }
                if (trace) {
                    log.tracef("Last pruned transaction ids were updated: %d, %s", this.globalMaxPrunedTxId, (Object)this.nodeMaxPrunedTxIds);
                }
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Failed to cleanup completed transactions: %s", (Object)e.getMessage());
            }
        }

        private void updateLastPrunedTxId(long txId, Address address) {
            if (txId > this.globalMaxPrunedTxId) {
                this.globalMaxPrunedTxId = txId;
            }
            this.nodeMaxPrunedTxIds.compute(address, (a, nodeMaxPrunedTxId) -> {
                if (nodeMaxPrunedTxId != null && txId <= nodeMaxPrunedTxId) {
                    return nodeMaxPrunedTxId;
                }
                return txId;
            });
        }
    }

    public static enum CompletedTransactionStatus {
        NOT_COMPLETED,
        COMMITTED,
        ABORTED,
        EXPIRED;

    }
}

