/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.table;

import infinispan.org.iq80.leveldb.table.BlockBuilder;
import infinispan.org.iq80.leveldb.table.UserComparator;
import infinispan.org.iq80.leveldb.util.Slice;

public class BytewiseComparator
implements UserComparator {
    @Override
    public String name() {
        return "leveldb.BytewiseComparator";
    }

    @Override
    public int compare(Slice sliceA, Slice sliceB) {
        return sliceA.compareTo(sliceB);
    }

    @Override
    public Slice findShortestSeparator(Slice start, Slice limit) {
        short lastSharedByte;
        int sharedBytes = BlockBuilder.calculateSharedBytes(start, limit);
        if (sharedBytes < Math.min(start.length(), limit.length()) && (lastSharedByte = start.getUnsignedByte(sharedBytes)) < 255 && lastSharedByte + 1 < limit.getUnsignedByte(sharedBytes)) {
            Slice result = start.copySlice(0, sharedBytes + 1);
            result.setByte(sharedBytes, lastSharedByte + 1);
            assert (this.compare(result, limit) < 0) : "start must be less than last limit";
            return result;
        }
        return start;
    }

    @Override
    public Slice findShortSuccessor(Slice key) {
        for (int i = 0; i < key.length(); ++i) {
            short b = key.getUnsignedByte(i);
            if (b == 255) continue;
            Slice result = key.copySlice(0, i + 1);
            result.setByte(i, b + 1);
            return result;
        }
        return key;
    }
}

