/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;

public class EntrySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public EntrySetCommand(Cache<K, V> cache, Set<Flag> flags) {
        this.setFlags(flags);
        this.cache = flags != null ? cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()])) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public Set<CacheEntry<K, V>> perform(InvocationContext ctx) throws Throwable {
        return new BackingEntrySet((Cache)this.cache);
    }

    public String toString() {
        return "EntrySetCommand{cache=" + this.cache.getName() + '}';
    }

    private static class EntryWrapper<K, V>
    extends ForwardingCacheEntry<K, V> {
        private final Cache<K, V> cache;
        private final CacheEntry<K, V> entry;

        public EntryWrapper(Cache<K, V> cache, CacheEntry<K, V> entry) {
            this.cache = cache;
            this.entry = entry;
        }

        @Override
        protected CacheEntry<K, V> delegate() {
            return this.entry;
        }

        @Override
        public V setValue(V value) {
            this.cache.put(this.entry.getKey(), value);
            return super.setValue(value);
        }
    }

    private static class EntryWrapperIterator<K, V>
    implements CloseableIterator<CacheEntry<K, V>> {
        private final Cache<K, V> cache;
        private final Iterator<CacheEntry<K, V>> iterator;

        public EntryWrapperIterator(Cache<K, V> cache, Iterator<CacheEntry<K, V>> iterator) {
            this.cache = cache;
            this.iterator = iterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CacheEntry<K, V> next() {
            CacheEntry<K, V> entry = this.iterator.next();
            return new EntryWrapper<K, V>(this.cache, entry);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static class BackingEntrySet<K, V>
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        BackingEntrySet(Cache cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            DataContainerRemoveIterator iterator = new DataContainerRemoveIterator(this.cache);
            return new EntryWrapperIterator(this.cache, iterator);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            DataContainer dc = this.cache.getAdvancedCache().getDataContainer();
            return Closeables.spliterator(Closeables.iterator(new DataContainerRemoveIterator(this.cache, dc)), dc.size(), 4353);
        }

        @Override
        public int size() {
            return this.cache.getAdvancedCache().getDataContainer().size();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                Object value = this.cache.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            return entry != null && this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean add(CacheEntry<K, V> internalCacheEntry) {
            throw new UnsupportedOperationException();
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        private ConsistentHash getConsistentHash(Cache<K, V> cache) {
            DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
            if (dm != null) {
                return dm.getReadConsistentHash();
            }
            return null;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, this.getConsistentHash(this.cache), () -> super.stream()), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, this.getConsistentHash(this.cache), () -> super.stream()), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

