/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.topology.PersistentUUID;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.UUID;

public class JGroupsAddressCache {
    private static final EquivalentConcurrentHashMapV8<org.jgroups.Address, JGroupsAddress> addressCache = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
    private static final EquivalentConcurrentHashMapV8<org.jgroups.Address, PersistentUUID> persistentUUIDCache = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());

    static Address fromJGroupsAddress(Object address) {
        org.jgroups.Address jgAddress = (org.jgroups.Address)address;
        JGroupsAddress ispnAddress = addressCache.get(jgAddress);
        if (ispnAddress != null) {
            return ispnAddress;
        }
        return addressCache.computeIfAbsent(jgAddress, uuid -> {
            if (jgAddress instanceof ExtendedUUID) {
                return new JGroupsTopologyAwareAddress((ExtendedUUID)jgAddress);
            }
            return new JGroupsAddress(jgAddress);
        });
    }

    public static void putAddressPersistentUUID(Object address, PersistentUUID localUUID) {
        org.jgroups.Address jgAddress = ((JGroupsAddress)address).address;
        persistentUUIDCache.put(jgAddress, localUUID);
    }

    public static PersistentUUID getPersistentUUID(Object address) {
        org.jgroups.Address jgAddress = ((JGroupsAddress)address).address;
        return persistentUUIDCache.get(jgAddress);
    }

    static void pruneAddressCache() {
        addressCache.forEachKey(Integer.MAX_VALUE, address -> {
            if (UUID.get(address) == null) {
                addressCache.remove(address);
                persistentUUIDCache.remove(address);
            }
        });
    }
}

