/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.executor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Channel;
import org.jgroups.blocks.executor.ExecutionCompletionService;
import org.jgroups.blocks.executor.ExecutorEvent;
import org.jgroups.blocks.executor.ExecutorNotification;
import org.jgroups.protocols.Executing;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ExecutionService
extends AbstractExecutorService {
    protected Channel ch;
    protected Executing _execProt;
    protected Lock _unfinishedLock = new ReentrantLock();
    protected Condition _unfinishedCondition = this._unfinishedLock.newCondition();
    protected Set<Future<?>> _unfinishedFutures = new HashSet();
    protected AtomicBoolean _shutdown = new AtomicBoolean(false);

    public ExecutionService() {
    }

    public ExecutionService(Channel ch) {
        this.setChannel(ch);
    }

    public void setChannel(Channel ch) {
        this.ch = ch;
        this._execProt = (Executing)ch.getProtocolStack().findProtocol((Class<?>)Executing.class);
        if (this._execProt == null) {
            throw new IllegalStateException("Channel configuration must include a executing protocol (subclass of " + Executing.class.getName() + ")");
        }
    }

    public <T> NotifyingFuture<T> submit(Runnable task, T result) {
        return (NotifyingFuture)super.submit(task, result);
    }

    public <T> NotifyingFuture<T> submit(Callable<T> task) {
        return (NotifyingFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this._realShutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Runnable> _realShutdown(boolean interrupt) {
        HashSet futures;
        this._shutdown.set(true);
        this._unfinishedLock.lock();
        try {
            futures = new HashSet(this._unfinishedFutures);
        }
        finally {
            this._unfinishedLock.unlock();
        }
        return (List)this.ch.down(new ExecutorEvent(1028, new Object[]{futures, interrupt}));
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._realShutdown(true);
    }

    @Override
    public boolean isShutdown() {
        return this._shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        if (this._shutdown.get()) {
            this._unfinishedLock.lock();
            try {
                boolean bl = this._unfinishedFutures.isEmpty();
                return bl;
            }
            finally {
                this._unfinishedLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanoTimeWait = unit.toNanos(timeout);
        this._unfinishedLock.lock();
        try {
            while (!this._unfinishedFutures.isEmpty()) {
                if ((nanoTimeWait = this._unfinishedCondition.awaitNanos(nanoTimeWait)) > 0L) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._unfinishedLock.unlock();
        }
        return true;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<Future<T>> futures;
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future<T>>(ntasks);
            ExecutionCompletionService<T> ecs = new ExecutionCompletionService<T>(this);
            ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object v;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    v = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)v;
                break;
            }
            if (ee != null) break block18;
            ee = new ExecutionException(){
                private static final long serialVersionUID = 200818694545553992L;
            };
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable command) {
        Callable serializeCheck;
        if (this._shutdown.get()) throw new RejectedExecutionException();
        DistributedFuture distFuture = null;
        if (command instanceof DistributedFuture) {
            distFuture = (DistributedFuture)command;
            serializeCheck = distFuture.getCallable();
            if (serializeCheck instanceof RunnableAdapter) {
                serializeCheck = ((RunnableAdapter)serializeCheck).task;
            }
        } else {
            serializeCheck = command;
        }
        if (!(serializeCheck instanceof Serializable) && !(serializeCheck instanceof Streamable)) throw new IllegalArgumentException("Command was not Serializable or Streamable - " + serializeCheck);
        if (distFuture != null) {
            this._execProt.addExecutorListener(distFuture, distFuture);
            this._unfinishedLock.lock();
            try {
                this._unfinishedFutures.add(distFuture);
            }
            finally {
                this._unfinishedLock.unlock();
            }
        }
        this.ch.down(new ExecutorEvent(1024, command));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        DistributedFuture<T> future = new DistributedFuture<T>(this.ch, this._unfinishedLock, this._unfinishedCondition, this._unfinishedFutures, runnable, value);
        return future;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        DistributedFuture<T> future = new DistributedFuture<T>(this.ch, this._unfinishedLock, this._unfinishedCondition, this._unfinishedFutures, callable);
        return future;
    }

    protected static final class RunnableAdapter<T>
    implements Callable<T>,
    Streamable {
        protected Runnable task;
        protected T result;

        public RunnableAdapter() {
        }

        protected RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            try {
                Util.writeObject(this.task, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Exception encountered while writing execution runnable", e);
            }
            try {
                Util.writeObject(this.result, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Exception encountered while writing execution result", e);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            try {
                this.task = (Runnable)Util.readObject(in);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Exception encountered while reading execution runnable", e);
            }
            try {
                this.result = Util.readObject(in);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Exception encountered while reading execution result", e);
            }
        }
    }

    public static class DistributedFuture<V>
    implements RunnableFuture<V>,
    ExecutorNotification,
    NotifyingFuture<V> {
        protected final Sync<V> sync;
        private final Channel channel;
        private final Set<Future<?>> _unfinishedFutures;
        private final Lock _unfinishedLock;
        private final Condition _unfinishedCondition;
        private volatile FutureListener<V> _listener;

        public String toString() {
            return "DistributedFuture [callable=" + this.sync.callable + "]";
        }

        public DistributedFuture(Channel channel, Lock unfinishedLock, Condition condition, Set<Future<?>> futuresToFinish, Callable<V> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.sync = new Sync<V>(this, callable);
            this.channel = channel;
            this._unfinishedFutures = futuresToFinish;
            this._unfinishedLock = unfinishedLock;
            this._unfinishedCondition = condition;
        }

        public DistributedFuture(Channel channel, Lock unfinishedLock, Condition condition, Set<Future<?>> futuresToFinish, Runnable runnable, V result) {
            this.sync = new Sync<V>(this, new RunnableAdapter<V>(runnable, result));
            this.channel = channel;
            this._unfinishedFutures = futuresToFinish;
            this._unfinishedLock = unfinishedLock;
            this._unfinishedCondition = condition;
        }

        public Callable<V> getCallable() {
            return this.sync.callable;
        }

        @Override
        public boolean isCancelled() {
            return this.sync.innerIsCancelled();
        }

        @Override
        public boolean isDone() {
            return this.sync.innerIsDone();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.sync.innerIsDone()) {
                return false;
            }
            if (this.channel != null) {
                return (Boolean)this.channel.down(new ExecutorEvent(1027, new Object[]{this, mayInterruptIfRunning}));
            }
            return this.sync.innerCancel(mayInterruptIfRunning);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.sync.innerGet();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.sync.innerGet(unit.toNanos(timeout));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            this._unfinishedLock.lock();
            try {
                this._unfinishedFutures.remove(this);
                this._unfinishedCondition.signalAll();
            }
            finally {
                this._unfinishedLock.unlock();
            }
            FutureListener<V> listener = this._listener;
            if (listener != null) {
                listener.futureDone(this);
            }
        }

        @Override
        public NotifyingFuture<V> setListener(FutureListener<V> listener) {
            this._listener = listener;
            if (this.sync.innerIsDone()) {
                this._listener.futureDone(this);
            }
            return this;
        }

        protected void set(V v) {
            this.sync.innerSet(v);
        }

        protected void setException(Throwable t) {
            this.sync.innerSetException(t);
        }

        @Override
        public void run() {
            this.sync.innerRun();
        }

        @Override
        public void resultReturned(Object obj) {
            this.set(obj);
        }

        @Override
        public void throwableEncountered(Throwable t) {
            this.setException(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupted(Runnable runnable) {
            this._unfinishedLock.lock();
            try {
                this._unfinishedFutures.remove(this);
                this._unfinishedCondition.signalAll();
            }
            finally {
                this._unfinishedLock.unlock();
            }
            FutureListener<V> listener = this._listener;
            if (listener != null) {
                listener.futureDone(this);
            }
        }

        protected static final class Sync<V>
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = -7828117401763700385L;
            protected static final int RUNNING = 1;
            protected static final int RAN = 2;
            protected static final int CANCELLED = 4;
            protected final DistributedFuture<V> future;
            protected final Callable<V> callable;
            protected V result;
            protected Throwable exception;
            protected volatile transient Thread runner;

            public Sync(DistributedFuture<V> future, Callable<V> callable) {
                this.future = future;
                this.callable = callable;
            }

            private static boolean ranOrCancelled(int state) {
                return (state & 6) != 0;
            }

            @Override
            protected int tryAcquireShared(int ignore) {
                return this.innerIsDone() ? 1 : -1;
            }

            @Override
            protected boolean tryReleaseShared(int ignore) {
                this.runner = null;
                return true;
            }

            boolean innerIsCancelled() {
                return this.getState() == 4;
            }

            boolean innerIsDone() {
                return Sync.ranOrCancelled(this.getState()) && this.runner == null;
            }

            V innerGet() throws InterruptedException, ExecutionException {
                this.acquireSharedInterruptibly(0);
                if (this.getState() == 4) {
                    throw new CancellationException();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                return this.result;
            }

            V innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
                if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                    throw new TimeoutException();
                }
                if (this.getState() == 4) {
                    throw new CancellationException();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                return this.result;
            }

            void innerSet(V v) {
                int s;
                do {
                    if ((s = this.getState()) == 2) {
                        return;
                    }
                    if (s != 4) continue;
                    this.releaseShared(0);
                    return;
                } while (!this.compareAndSetState(s, 2));
                this.result = v;
                this.releaseShared(0);
                this.future.done();
            }

            void innerSetException(Throwable t) {
                int s;
                do {
                    if ((s = this.getState()) == 2) {
                        return;
                    }
                    if (s != 4) continue;
                    this.releaseShared(0);
                    return;
                } while (!this.compareAndSetState(s, 2));
                this.exception = t;
                this.result = null;
                this.releaseShared(0);
                this.future.done();
            }

            boolean innerCancel(boolean mayInterruptIfRunning) {
                Thread r;
                int s;
                do {
                    if (!Sync.ranOrCancelled(s = this.getState())) continue;
                    return false;
                } while (!this.compareAndSetState(s, 4));
                if (mayInterruptIfRunning && (r = this.runner) != null) {
                    r.interrupt();
                }
                this.releaseShared(0);
                this.future.done();
                return true;
            }

            void innerRun() {
                if (!this.compareAndSetState(0, 1)) {
                    return;
                }
                try {
                    this.runner = Thread.currentThread();
                    if (this.getState() == 1) {
                        this.innerSet(this.callable.call());
                    } else {
                        this.releaseShared(0);
                    }
                }
                catch (Throwable ex) {
                    this.innerSetException(ex);
                }
            }

            boolean innerRunAndReset() {
                if (!this.compareAndSetState(0, 1)) {
                    return false;
                }
                try {
                    this.runner = Thread.currentThread();
                    if (this.getState() == 1) {
                        this.callable.call();
                    }
                    this.runner = null;
                    return this.compareAndSetState(1, 0);
                }
                catch (Throwable ex) {
                    this.innerSetException(ex);
                    return false;
                }
            }
        }
    }
}

