/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.io.UnsignedNumeric;

@Immutable
public class MarshallUtil {
    private static final byte NULL_VALUE = -1;

    public static void marshallCollection(Collection<?> c, ObjectOutput out) throws IOException {
        UnsignedNumeric.writeUnsignedInt(out, c.size());
        for (Object o : c) {
            out.writeObject(o);
        }
    }

    public static void marshallMap(Map<?, ?> map, ObjectOutput out) throws IOException {
        int mapSize = map.size();
        UnsignedNumeric.writeUnsignedInt(out, mapSize);
        if (mapSize == 0) {
            return;
        }
        for (Map.Entry<?, ?> me : map.entrySet()) {
            out.writeObject(me.getKey());
            out.writeObject(me.getValue());
        }
    }

    public static void unmarshallMap(Map<Object, Object> map, ObjectInput in) throws IOException, ClassNotFoundException {
        int size = UnsignedNumeric.readUnsignedInt(in);
        for (int i = 0; i < size; ++i) {
            map.put(in.readObject(), in.readObject());
        }
    }

    public static <E extends Enum<E>> void marshallEnum(E e, ObjectOutput output) throws IOException {
        if (e == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(e.ordinal());
        }
    }

    public static <E extends Enum<E>> E unmarshallEnum(ObjectInput input, EnumBuilder<E> builder) throws IOException {
        byte ordinal = input.readByte();
        if (ordinal == -1) {
            return null;
        }
        try {
            return Objects.requireNonNull(builder).build(ordinal);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Unknown enum.", e);
        }
    }

    public static interface EnumBuilder<E extends Enum<E>> {
        public E build(int var1);
    }
}

