/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class ClearCommand
extends AbstractFlagAffectedCommand
implements WriteCommand {
    public static final byte COMMAND_ID = 5;
    private CacheNotifier<Object, Object> notifier;
    private DataContainer<?, ?> dataContainer;

    public ClearCommand() {
    }

    public ClearCommand(CacheNotifier<Object, Object> notifier, DataContainer<?, ?> dataContainer, Set<Flag> flags) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
        this.flags = flags;
    }

    public void init(CacheNotifier<Object, Object> notifier, DataContainer<?, ?> dataContainer) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitClearCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (CacheEntry cacheEntry : this.dataContainer.entrySet()) {
            this.notifier.notifyCacheEntryRemoved(cacheEntry.getKey(), cacheEntry.getValue(), cacheEntry.getMetadata(), true, ctx, this);
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 5;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.flags = (Set)input.readObject();
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    public String toString() {
        return "ClearCommand{flags=" + this.flags + "}";
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return InfinispanCollections.emptySet();
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }
}

