/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BackupForBuilder
extends AbstractConfigurationChildBuilder
implements Builder<BackupForConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final AttributeSet attributes = BackupForConfiguration.attributeDefinitionSet();

    public BackupForBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public BackupForBuilder remoteSite(String siteName) {
        this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).set(siteName);
        return this;
    }

    public BackupForBuilder remoteCache(String name) {
        if (name == null) {
            throw log.backupForNullCache();
        }
        this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).set(name);
        return this;
    }

    public BackupForBuilder defaultRemoteCache() {
        this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).set("___defaultcache");
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).get() == null && this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).get() == null) {
            return;
        }
        if (this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).get() == null || this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).get() == null) {
            throw log.backupForMissingParameters();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public BackupForConfiguration create() {
        return new BackupForConfiguration(this.attributes.protect());
    }

    public BackupForBuilder read(BackupForConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "BackupForBuilder [attributes=" + this.attributes + "]";
    }

    public void reset() {
        this.attributes.reset();
    }
}

