/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class MarshalledValueInterceptor<K, V>
extends CommandInterceptor {
    private StreamingMarshaller marshaller;
    private boolean wrapKeys = true;
    private boolean wrapValues = true;
    private InternalEntryFactory entryFactory;
    private Cache<K, V> cache;
    private static final Log log = LogFactory.getLog(MarshalledValueInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void inject(@ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, InternalEntryFactory entryFactory, Cache<K, V> cache) {
        this.marshaller = marshaller;
        this.entryFactory = entryFactory;
        this.cache = cache;
    }

    @Start
    protected void start() {
        this.wrapKeys = this.cacheConfiguration.storeAsBinary().storeKeysAsBinary();
        this.wrapValues = this.cacheConfiguration.storeAsBinary().storeValuesAsBinary();
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (this.wrapKeys) {
            if (command.multipleKeys()) {
                Collection<Object> rawKeys = command.getKeys();
                HashMap<Object, Object> keyToMarshalledKeyMapping = new HashMap<Object, Object>(rawKeys.size());
                for (Object k : rawKeys) {
                    if (MarshalledValue.isTypeExcluded(k.getClass())) continue;
                    keyToMarshalledKeyMapping.put(k, this.createMarshalledValue(k, ctx));
                }
                if (!keyToMarshalledKeyMapping.isEmpty()) {
                    command.replaceKeys(keyToMarshalledKeyMapping);
                }
            } else {
                Object key = command.getSingleKey();
                if (!MarshalledValue.isTypeExcluded(key.getClass())) {
                    command.replaceKey(key, this.createMarshalledValue(key, ctx));
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>(command.getMap().size());
        Map<Object, Object> map = this.wrapMap(command.getMap(), marshalledValues, ctx);
        command.setMap(map);
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getValue().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getValue(), ctx);
            command.setValue(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue mv = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(mv);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (this.wrapKeys) {
            LinkedHashSet<MarshalledValue> marshalledKeys = new LinkedHashSet<MarshalledValue>();
            for (Object key : command.getKeys()) {
                if (!MarshalledValue.isTypeExcluded(key.getClass())) {
                    MarshalledValue mv = this.createMarshalledValue(key, ctx);
                    marshalledKeys.add(mv);
                    continue;
                }
                marshalledKeys.add((MarshalledValue)key);
            }
            command.setKeys(marshalledKeys);
        }
        Map map = (Map)this.invokeNextInterceptor(ctx, command);
        Map unmarshalled = command.createMap();
        for (Map.Entry entry : map.entrySet()) {
            unmarshalled.put(this.processRetVal(entry.getKey(), ctx), this.processRetVal(entry.getValue(), ctx));
        }
        return unmarshalled;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getNewValue().getClass())) {
            MarshalledValue newValue = this.createMarshalledValue(command.getNewValue(), ctx);
            command.setNewValue(newValue);
        }
        if (this.wrapValues && command.getOldValue() != null && !MarshalledValue.isTypeExcluded(command.getOldValue().getClass())) {
            MarshalledValue oldValue = this.createMarshalledValue(command.getOldValue(), ctx);
            command.setOldValue(oldValue);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    protected <R> R processRetVal(R retVal, InvocationContext ctx) {
        if (retVal instanceof MarshalledValue && (ctx == null || ctx.isOriginLocal())) {
            if (trace) {
                log.tracef("Return is a marshall value, so extract instance from: %s", retVal);
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    private final CacheEntry<K, V> unwrapEntry(CacheEntry<K, V> e, InvocationContext ctx) {
        K originalKey = e.getKey();
        K key = this.processRetVal(originalKey, ctx);
        V originalValue = e.getValue();
        V value = this.processRetVal(originalValue, ctx);
        if (originalKey != key || originalValue != value) {
            return this.entryFactory.create(key, value, e.getMetadata());
        }
        return e;
    }

    @Override
    public CacheSet<CacheEntry<K, V>> visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        CacheSet set = (CacheSet)super.visitEntrySetCommand(ctx, command);
        return new AbstractDelegatingEntryCacheSet<K, V>(this.getCacheWithFlags(this.cache, command), set){

            @Override
            public CloseableIterator<CacheEntry<K, V>> iterator() {
                return new CloseableIteratorMapper<CacheEntry, CacheEntry>((CloseableIterator<CacheEntry>)super.iterator(), e -> MarshalledValueInterceptor.this.unwrapEntry(e, null));
            }

            @Override
            public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
                return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
            }
        };
    }

    @Override
    public CacheSet<K> visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        CacheSet set = (CacheSet)super.visitKeySetCommand(ctx, command);
        return new AbstractDelegatingKeyCacheSet<K, V>(this.getCacheWithFlags(this.cache, command), set){

            @Override
            public CloseableIterator<K> iterator() {
                return new CloseableIteratorMapper<Object, Object>((CloseableIterator<Object>)super.iterator(), e -> MarshalledValueInterceptor.this.processRetVal(e, null));
            }

            @Override
            public CloseableSpliterator<K> spliterator() {
                return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
            }
        };
    }

    protected Map<Object, Object> wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) {
        if (m == null) {
            if (trace) {
                log.trace("Map is nul; returning an empty map.");
            }
            return InfinispanCollections.emptyMap();
        }
        if (trace) {
            log.tracef("Wrapping map contents of argument %s", (Object)m);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>(m.size());
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object newValue;
            Object key = me.getKey();
            Object value = me.getValue();
            Object newKey = key == null || MarshalledValue.isTypeExcluded(key.getClass()) || !this.wrapKeys ? key : this.createMarshalledValue(key, ctx);
            Object object = newValue = value == null || MarshalledValue.isTypeExcluded(value.getClass()) || !this.wrapValues ? value : this.createMarshalledValue(value, ctx);
            if (newKey instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newKey);
            }
            if (newValue instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newValue);
            }
            copy.put(newKey, newValue);
        }
        return copy;
    }

    protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) {
        return new MarshalledValue(toWrap, this.marshaller);
    }
}

