/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;

public class CompletableFutures {
    private static final CompletableFuture completedEmptyMapFuture = CompletableFuture.completedFuture(InfinispanCollections.emptyMap());
    public static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);

    public static <K, V> CompletableFuture<Map<K, V>> returnEmptyMap() {
        return completedEmptyMapFuture;
    }

    public static <T> void connect(NotifyingNotifiableFuture<T> sink, CompletableFuture<T> source) {
        CompletionStage compoundSource = source.whenComplete((value, throwable) -> {
            if (throwable == null) {
                sink.notifyDone(value);
            } else {
                sink.notifyException((Throwable)throwable);
            }
        });
        sink.setFuture((Future<T>)((Object)compoundSource));
    }

    public static <T> CompletableFuture<T> toCompletableFuture(NotifyingFuture<T> source) {
        CompletableFuture result = new CompletableFuture();
        source.attachListener(f -> {
            try {
                result.complete(f.get());
            }
            catch (Exception e) {
                result.cancel(false);
            }
        });
        return result;
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        return all.thenApply(v -> futures.stream().map(future -> future.join()).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> completedExceptionFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static boolean await(CompletableFuture<?> future, long time, TimeUnit unit) throws InterruptedException {
        try {
            Objects.requireNonNull(future, "Completable Future must be non-null.").get(time, Objects.requireNonNull(unit, "Time Unit must be non-null"));
            return true;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public static <T> T await(CompletableFuture<T> future) throws ExecutionException, InterruptedException {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
    }
}

