/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.metadata.Metadata;

public class MetadataMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected Object value;
    protected Metadata metadata;
    protected long created;

    public MetadataMortalCacheEntry(Object key, Object value, Metadata metadata, long created) {
        super(key);
        this.value = value;
        this.metadata = metadata;
        this.created = created;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.metadata.lifespan(), this.created, now);
    }

    @Override
    public final boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public final long getCreated() {
        return this.created;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        long lifespan = this.metadata.lifespan();
        return lifespan > -1L ? this.created + lifespan : -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public final void touch(long currentTimeMillis) {
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    public InternalCacheValue toInternalCacheValue() {
        return new MetadataMortalCacheValue(this.value, this.metadata, this.created);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
            output.writeObject(ice.metadata);
            UnsignedNumeric.writeUnsignedLong(output, ice.created);
        }

        @Override
        public MetadataMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataMortalCacheEntry(k, v, metadata, created);
        }

        @Override
        public Integer getId() {
            return 77;
        }

        @Override
        public Set<Class<? extends MetadataMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataMortalCacheEntry.class);
        }
    }
}

