/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.client.hotrod.impl.operations.AuthOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class SaslTransportObjectFactory
extends TransportObjectFactory {
    private static final Log log = LogFactory.getLog(SaslTransportObjectFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String AUTH_INT = "auth-int";
    private static final String AUTH_CONF = "auth-conf";
    private final AuthenticationConfiguration authConfiguration;

    public SaslTransportObjectFactory(Codec codec, TcpTransportFactory tcpTransportFactory, AtomicInteger defaultCacheTopologyId, boolean pingOnStartup, AuthenticationConfiguration authConfiguration, Configuration configuration) {
        super(codec, tcpTransportFactory, defaultCacheTopologyId, pingOnStartup, configuration);
        this.authConfiguration = authConfiguration;
    }

    @Override
    public TcpTransport makeObject(SocketAddress address) throws Exception {
        List<String> serverMechs;
        TcpTransport tcpTransport = new TcpTransport(address, this.tcpTransportFactory);
        if (trace) {
            log.tracef("Created tcp transport: %s", (Object)tcpTransport);
        }
        if (!(serverMechs = this.mechList(tcpTransport, this.defaultCacheTopologyId)).contains(this.authConfiguration.saslMechanism())) {
            throw log.unsupportedMech(this.authConfiguration.saslMechanism(), serverMechs);
        }
        SaslClient saslClient = this.authConfiguration.clientSubject() != null ? Subject.doAs(this.authConfiguration.clientSubject(), new PrivilegedExceptionAction<SaslClient>(){

            @Override
            public SaslClient run() throws Exception {
                CallbackHandler callbackHandler = SaslTransportObjectFactory.this.authConfiguration.callbackHandler();
                if (callbackHandler == null) {
                    callbackHandler = NoOpCallbackHandler.INSTANCE;
                }
                return Sasl.createSaslClient(new String[]{SaslTransportObjectFactory.this.authConfiguration.saslMechanism()}, null, "hotrod", SaslTransportObjectFactory.this.authConfiguration.serverName(), SaslTransportObjectFactory.this.authConfiguration.saslProperties(), callbackHandler);
            }
        }) : Sasl.createSaslClient(new String[]{this.authConfiguration.saslMechanism()}, null, "hotrod", this.authConfiguration.serverName(), this.authConfiguration.saslProperties(), this.authConfiguration.callbackHandler());
        if (trace) {
            log.tracef("Authenticating using mech: %s", (Object)this.authConfiguration.saslMechanism());
        }
        byte[] response = saslClient.hasInitialResponse() ? this.evaluateChallenge(saslClient, EMPTY_BYTES) : EMPTY_BYTES;
        byte[] challenge = this.auth(tcpTransport, this.defaultCacheTopologyId, this.authConfiguration.saslMechanism(), response);
        while (!saslClient.isComplete() && challenge != null && (response = this.evaluateChallenge(saslClient, challenge)) != null) {
            challenge = this.auth(tcpTransport, this.defaultCacheTopologyId, "", response);
        }
        String qop = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        if (qop != null && (qop.equalsIgnoreCase(AUTH_INT) || qop.equalsIgnoreCase(AUTH_CONF))) {
            tcpTransport.setSaslClient(saslClient);
        } else {
            saslClient.dispose();
        }
        if (this.pingOnStartup && !this.firstPingExecuted) {
            log.trace("Executing first ping!");
            this.firstPingExecuted = true;
            this.ping(tcpTransport, this.defaultCacheTopologyId);
        }
        return tcpTransport;
    }

    private byte[] evaluateChallenge(final SaslClient saslClient, final byte[] challenge) throws SaslException {
        if (this.authConfiguration.clientSubject() != null) {
            try {
                return Subject.doAs(this.authConfiguration.clientSubject(), new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return saslClient.evaluateChallenge(challenge);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SaslException) {
                    throw (SaslException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return saslClient.evaluateChallenge(challenge);
    }

    private List<String> mechList(TcpTransport tcpTransport, AtomicInteger topologyId) {
        AuthMechListOperation op = new AuthMechListOperation(this.codec, topologyId, this.configuration, tcpTransport);
        return op.execute();
    }

    private byte[] auth(TcpTransport tcpTransport, AtomicInteger topologyId, String mech, byte[] response) {
        AuthOperation op = new AuthOperation(this.codec, topologyId, this.configuration, tcpTransport, mech, response);
        return op.execute();
    }

    public static final class NoOpCallbackHandler
    implements CallbackHandler {
        public static final NoOpCallbackHandler INSTANCE = new NoOpCallbackHandler();

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        }
    }
}

