/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.xsite.BackupSender;

public class XSiteAdminCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 32;
    private String siteName;
    private Integer afterFailures;
    private Long minTimeToWait;
    private AdminOperation adminOperation;
    private BackupSender backupSender;

    public XSiteAdminCommand() {
        super(null);
    }

    public XSiteAdminCommand(String cacheName) {
        super(cacheName);
    }

    public XSiteAdminCommand(String cacheName, String siteName, AdminOperation op, Integer afterFailures, Long minTimeToWait) {
        this(cacheName);
        this.siteName = siteName;
        this.adminOperation = op;
        this.afterFailures = afterFailures;
        this.minTimeToWait = minTimeToWait;
    }

    public void init(BackupSender backupSender) {
        this.backupSender = backupSender;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.adminOperation) {
            case SITE_STATUS: {
                if (this.backupSender.getOfflineStatus(this.siteName).isOffline()) {
                    return Status.OFFLINE;
                }
                return Status.ONLINE;
            }
            case STATUS: {
                return this.backupSender.status();
            }
            case TAKE_OFFLINE: {
                return this.backupSender.takeSiteOffline(this.siteName);
            }
            case BRING_ONLINE: {
                return this.backupSender.bringSiteOnline(this.siteName);
            }
            case AMEND_TAKE_OFFLINE: {
                this.backupSender.getOfflineStatus(this.siteName).amend(this.afterFailures, this.minTimeToWait);
                return null;
            }
        }
        throw new IllegalStateException("Unhandled admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public byte getCommandId() {
        return 32;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum(this.adminOperation, output);
        switch (this.adminOperation) {
            case SITE_STATUS: 
            case TAKE_OFFLINE: 
            case BRING_ONLINE: {
                output.writeUTF(this.siteName);
                return;
            }
            case AMEND_TAKE_OFFLINE: {
                output.writeUTF(this.siteName);
                output.writeObject(this.afterFailures);
                output.writeObject(this.minTimeToWait);
                return;
            }
            case STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.adminOperation = MarshallUtil.unmarshallEnum(input, ordinal -> AdminOperation.CACHED_VALUES[ordinal]);
        switch (this.adminOperation) {
            case SITE_STATUS: 
            case TAKE_OFFLINE: 
            case BRING_ONLINE: {
                this.siteName = input.readUTF();
                return;
            }
            case AMEND_TAKE_OFFLINE: {
                this.siteName = input.readUTF();
                this.afterFailures = (Integer)input.readObject();
                this.minTimeToWait = (Long)input.readObject();
                return;
            }
            case STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteAdminCommand{siteName='" + this.siteName + '\'' + ", afterFailures=" + this.afterFailures + ", minTimeToWait=" + this.minTimeToWait + ", adminOperation=" + (Object)((Object)this.adminOperation) + ", backupSender=" + this.backupSender + '}';
    }

    public static enum Status {
        OFFLINE,
        ONLINE;

    }

    public static enum AdminOperation {
        SITE_STATUS,
        STATUS,
        TAKE_OFFLINE,
        BRING_ONLINE,
        AMEND_TAKE_OFFLINE;

        private static final AdminOperation[] CACHED_VALUES;

        static {
            CACHED_VALUES = AdminOperation.values();
        }
    }
}

