/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.impl.parser.mappers.ProtofileMapper;
import protostream.com.squareup.protoparser.ProtoFile;
import protostream.com.squareup.protoparser.ProtoSchemaParser;

public final class SquareProtoParser
implements DescriptorParser {
    private static final ProtofileMapper PROTOFILE_MAPPER = new ProtofileMapper();
    private final Configuration configuration;

    public SquareProtoParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Map<String, FileDescriptor> parseAndResolve(FileDescriptorSource fileDescriptorSource) throws DescriptorParserException {
        Map<String, FileDescriptor> fileDescriptorMap = this.parse(fileDescriptorSource);
        HashMap<String, GenericDescriptor> types = new HashMap<String, GenericDescriptor>();
        for (FileDescriptor fileDescriptor : fileDescriptorMap.values()) {
            fileDescriptor.resolveDependencies(null, fileDescriptorMap, types);
            types.putAll(fileDescriptor.getTypes());
        }
        return fileDescriptorMap;
    }

    @Override
    public Map<String, FileDescriptor> parse(FileDescriptorSource fileDescriptorSource) throws DescriptorParserException {
        Map<String, char[]> input = fileDescriptorSource.getFileDescriptors();
        LinkedHashMap<String, FileDescriptor> fileDescriptorMap = new LinkedHashMap<String, FileDescriptor>(input.size());
        for (Map.Entry<String, char[]> entry : input.entrySet()) {
            String fileName = entry.getKey();
            try {
                ProtoFile protoFile = ProtoSchemaParser.parse(fileName, new CharArrayReader(entry.getValue()));
                FileDescriptor fileDescriptor = PROTOFILE_MAPPER.map(protoFile);
                fileDescriptor.setConfiguration(this.configuration);
                fileDescriptorMap.put(fileName, fileDescriptor);
            }
            catch (IOException e) {
                throw new DescriptorParserException("Internal parsing error : " + e.getMessage());
            }
            catch (DescriptorParserException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DescriptorParserException(e);
            }
        }
        return fileDescriptorMap;
    }
}

