/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.jgroups.Responses;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.util.FutureListener;
import org.jgroups.util.RspList;

public class RspListFuture
extends CompletableFuture<Responses>
implements FutureListener<RspList<Response>>,
Callable<Void> {
    private volatile GroupRequest<Response> request;
    private volatile Future<?> timeoutFuture = null;

    RspListFuture() {
    }

    public void setRequest(GroupRequest<Response> request) {
        this.request = request;
    }

    @Override
    public void futureDone(Future<RspList<Response>> future) {
        try {
            RspList<Response> rspList = future.get();
            this.complete(new Responses(rspList));
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    public void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
        if (this.isDone()) {
            timeoutFuture.cancel(false);
        }
    }

    @Override
    public Void call() throws Exception {
        Responses responses = new Responses(this.request.getResults());
        responses.setTimedOut();
        this.complete(responses);
        this.request.cancel(true);
        return null;
    }
}

