/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private boolean needToMarkReads;
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    public void start() {
        this.needToMarkReads = this.cacheConfiguration.clustering().cacheMode() == CacheMode.LOCAL && this.cacheConfiguration.locking().writeSkewCheck() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ && !this.cacheConfiguration.unsafe().unreliableReturnValues();
    }

    private void markKeyAsRead(InvocationContext ctx, DataCommand command, boolean forceRead) {
        if (this.needToMarkReads && ctx.isInTxScope() && (forceRead || !command.hasFlag(Flag.IGNORE_RETURN_VALUES))) {
            TxInvocationContext tctx = (TxInvocationContext)ctx;
            ((AbstractCacheTransaction)tctx.getCacheTransaction()).addReadKey(command.getKey());
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Collection<Object> keysToLock = command.getKeysToLock();
        ctx.addAllAffectedKeys(command.getAffectedKeys());
        if (!keysToLock.isEmpty()) {
            Collection<Object> lockedKeys;
            if (command.isRetriedCommand() && ctx.isOriginLocal()) {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).cleanupBackupLocks();
                keysToLock.removeAll(ctx.getLockedKeys());
            }
            if (!(lockedKeys = this.lockAllOrRegisterBackupLock(ctx, keysToLock, this.cacheConfiguration.locking().lockAcquisitionTimeout())).isEmpty()) {
                for (Object key : lockedKeys) {
                    this.performLocalWriteSkewCheck(ctx, key);
                }
            }
        }
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        this.markKeyAsRead(ctx, command, true);
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.markKeyAsRead(ctx, command, true);
        return super.visitGetKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (this.needToMarkReads && ctx.isInTxScope()) {
            TxInvocationContext tctx = (TxInvocationContext)ctx;
            for (Object key : command.getKeys()) {
                ((AbstractCacheTransaction)tctx.getCacheTransaction()).addReadKey(key);
            }
        }
        return super.visitGetAllCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            this.markKeyAsRead(ctx, command, command.isConditional());
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new InvalidCacheUsageException("Explicit locking is not allowed with optimistic caches!");
    }

    private void performLocalWriteSkewCheck(TxInvocationContext ctx, Object key) {
        CacheEntry ce = ctx.lookupEntry(key);
        if (ce instanceof RepeatableReadEntry && ((AbstractCacheTransaction)ctx.getCacheTransaction()).keyRead(key)) {
            if (trace) {
                log.tracef("Performing local write skew check for key %s", (Object)Util.toStr(key));
            }
            ((RepeatableReadEntry)ce).performLocalWriteSkewCheck(this.dataContainer, true);
        } else if (trace) {
            log.tracef("*Not* performing local write skew check for key %s", (Object)Util.toStr(key));
        }
    }
}

