/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.infinispan.distribution.util.ReadOnlySegmentAwareSet;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    private <T extends AbstractDataCommand> Object visitGetCommand(InvocationContext ctx, T command) throws Throwable {
        Object key;
        CacheEntry entry;
        if (ctx.isOriginLocal() && this.valueIsMissing(entry = ctx.lookupEntry(key = command.getKey()))) {
            InternalCacheEntry localEntry;
            InternalCacheEntry remoteEntry = null;
            if (this.readNeedsRemoteValue(ctx, command)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false);
                ((RemoteFetchingCommand)((Object)command)).setRemotelyFetchedValue(remoteEntry);
                if (remoteEntry != null) {
                    this.entryFactory.wrapExternalEntry(ctx, key, remoteEntry, EntryFactory.Wrap.STORE, false);
                }
            }
            if (remoteEntry == null && (localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key)) != null) {
                this.entryFactory.wrapExternalEntry(ctx, key, localEntry, EntryFactory.Wrap.STORE, false);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        CompletableFuture<Map<Address, Response>> future;
        PutMapCommand copy;
        Map<Object, Object> originalMap = command.getMap();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            HashMap primaryEntries = new HashMap();
            for (Map.Entry<Object, Object> entry : originalMap.entrySet()) {
                Object object = entry.getKey();
                Address address = ch.locatePrimaryOwner(object);
                if (localAddress.equals(address)) continue;
                HashMap currentEntries = (HashMap)primaryEntries.get(address);
                if (currentEntries == null) {
                    currentEntries = new HashMap();
                    primaryEntries.put(address, currentEntries);
                }
                currentEntries.put(object, entry.getValue());
            }
            ArrayList<CompletableFuture<Map<Address, Response>>> arrayList = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            for (Map.Entry entry : primaryEntries.entrySet()) {
                Map map = (Map)entry.getValue();
                if (map.isEmpty()) continue;
                copy = new PutMapCommand(command);
                copy.setMap(map);
                future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                arrayList.add(future);
            }
            if (arrayList.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[arrayList.size()];
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(arrayList.toArray(futuresArray));
                try {
                    completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException executionException) {
                    throw new RemoteException("Exception while processing put on primary owner", executionException.getCause());
                }
                catch (TimeoutException timeoutException) {
                    throw new CacheException(timeoutException);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerEntries = new HashMap();
            for (Map.Entry entry : originalMap.entrySet()) {
                Object key = entry.getKey();
                List<Address> list = ch.locateOwners(key);
                if (!localAddress.equals(list.get(0))) continue;
                for (int i = 1; i < list.size(); ++i) {
                    Address address = list.get(i);
                    HashMap entries = (HashMap)backupOwnerEntries.get(address);
                    if (entries == null) {
                        entries = new HashMap();
                        backupOwnerEntries.put(address, entries);
                    }
                    entries.put(key, entry.getValue());
                }
            }
            int backupOwnerSize = backupOwnerEntries.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> arrayList = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerEntries.entrySet()) {
                    copy = new PutMapCommand(command);
                    copy.setMap((Map)entry.getValue());
                    future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    arrayList.add(future);
                }
                command.setForwarded(false);
                if (arrayList.size() > 0) {
                    CompletableFuture[] completableFutureArray = new CompletableFuture[arrayList.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(arrayList.toArray(completableFutureArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        Object key;
        CacheEntry entry;
        if (ctx.isOriginLocal() && this.valueIsMissing(entry = ctx.lookupEntry(key = command.getKey()))) {
            InternalCacheEntry remoteEntry = null;
            if (this.readNeedsRemoteValue(ctx, command)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                if ((remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false)) != null) {
                    this.entryFactory.wrapExternalEntry(ctx, key, remoteEntry, EntryFactory.Wrap.STORE, false);
                }
                return command.perform(remoteEntry);
            }
            InternalCacheEntry localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key);
            if (localEntry != null) {
                this.entryFactory.wrapExternalEntry(ctx, key, localEntry, EntryFactory.Wrap.STORE, false);
            }
            return command.perform(localEntry);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return super.visitReadOnlyManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        Map originalMap = command.getEntries();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap segmentEntriesMap;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments)).isEmpty()) continue;
                WriteOnlyManyEntriesCommand writeOnlyManyEntriesCommand = new WriteOnlyManyEntriesCommand(command);
                writeOnlyManyEntriesCommand.setEntries(segmentEntriesMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), writeOnlyManyEntriesCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    Set segments = (Set)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    WriteOnlyManyEntriesCommand copy = new WriteOnlyManyEntriesCommand(command);
                    copy.setEntries(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        Set originalMap = command.getKeys();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareSet segmentKeysSet;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments)).isEmpty()) continue;
                WriteOnlyManyCommand writeOnlyManyCommand = new WriteOnlyManyCommand(command);
                writeOnlyManyCommand.setKeys(segmentKeysSet);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), writeOnlyManyCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    Set segments = (Set)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareSet segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments);
                    if (segmentKeysSet.isEmpty()) continue;
                    WriteOnlyManyCommand copy = new WriteOnlyManyCommand(command);
                    copy.setKeys(segmentKeysSet);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        Set originalMap = command.getKeys();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<Object> futures = new ArrayList<Object>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareSet readOnlySegmentAwareSet;
                Object segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (readOnlySegmentAwareSet = new ReadOnlySegmentAwareSet(originalMap, ch, (Set<Integer>)segments)).isEmpty()) continue;
                ReadWriteManyCommand readWriteManyCommand = new ReadWriteManyCommand(command);
                readWriteManyCommand.setKeys(readOnlySegmentAwareSet);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), readWriteManyCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    for (CompletableFuture completableFuture : futures) {
                        Map map = (Map)completableFuture.get();
                        for (Response response : map.values()) {
                            if (!response.isSuccessful()) continue;
                            SuccessfulResponse success = (SuccessfulResponse)response;
                            command.addAllRemoteReturns((List)success.getResponseValue());
                        }
                    }
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    void var11_21;
                    Address backupOwner = iter.next();
                    Set set = (Set)backupOwnerSegments.get(backupOwner);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        backupOwnerSegments.put(backupOwner, hashSet);
                    }
                    var11_21.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareSet segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments);
                    if (segmentKeysSet.isEmpty()) continue;
                    ReadWriteManyCommand copy = new ReadWriteManyCommand(command);
                    copy.setKeys(segmentKeysSet);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] completableFutureArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(completableFutureArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        Map originalMap = command.getEntries();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<Object> futures = new ArrayList<Object>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap readOnlySegmentAwareMap;
                Object segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (readOnlySegmentAwareMap = new ReadOnlySegmentAwareMap(originalMap, ch, (Set<Integer>)segments)).isEmpty()) continue;
                ReadWriteManyEntriesCommand readWriteManyEntriesCommand = new ReadWriteManyEntriesCommand(command);
                readWriteManyEntriesCommand.setEntries(readOnlySegmentAwareMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), readWriteManyEntriesCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    for (CompletableFuture completableFuture : futures) {
                        Map map = (Map)completableFuture.get();
                        for (Response response : map.values()) {
                            if (!response.isSuccessful()) continue;
                            SuccessfulResponse success = (SuccessfulResponse)response;
                            command.addAllRemoteReturns((List)success.getResponseValue());
                        }
                    }
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    void var11_21;
                    Address backupOwner = iter.next();
                    Set set = (Set)backupOwnerSegments.get(backupOwner);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        backupOwnerSegments.put(backupOwner, hashSet);
                    }
                    var11_21.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    ReadWriteManyEntriesCommand copy = new ReadWriteManyEntriesCommand(command);
                    copy.setEntries(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] completableFutureArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(completableFutureArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, Object key) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(key);
        if (!this.valueIsMissing(entry)) {
            return;
        }
        InternalCacheEntry remoteEntry = null;
        if (this.writeNeedsRemoteValue(ctx, command, key)) {
            InternalCacheEntry localEntry;
            if (!this.isValueAvailableLocally(this.dm.getReadConsistentHash(), key)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                if ((remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false)) != null) {
                    this.entryFactory.wrapExternalEntry(ctx, key, remoteEntry, EntryFactory.Wrap.STORE, false);
                }
            }
            if (remoteEntry == null && (localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key)) != null) {
                this.entryFactory.wrapExternalEntry(ctx, key, localEntry, EntryFactory.Wrap.STORE, false);
            }
        }
    }

    @Override
    protected boolean writeNeedsRemoteValue(InvocationContext ctx, WriteCommand command, Object key) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return false;
        }
        if (ctx.isOriginLocal() && command.hasFlag(Flag.SKIP_REMOTE_LOOKUP)) {
            return false;
        }
        return !ctx.isOriginLocal() && command.alwaysReadsExistingValues();
    }
}

