/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser90;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.leveldb.configuration.Attribute;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.Element;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:leveldb:9.0", root="leveldb-store"), @Namespace(root="leveldb-store")})
public class LevelDBStoreConfigurationParser90
implements ConfigurationParser {
    private static final Log log = LogFactory.getLog(LevelDBStoreConfigurationParser90.class);

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LEVELDB_STORE: {
                this.parseLevelDBCacheStore(reader, builder.persistence().addStore(LevelDBStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseLevelDBCacheStore(XMLExtendedStreamReader reader, LevelDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String attributeValue = reader.getAttributeValue(i);
            String value = StringPropertyReplacer.replaceProperties(attributeValue);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case PATH: {
                    builder.location(value);
                    continue block12;
                }
                case RELATIVE_TO: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block12;
                }
                case CLEAR_THRESHOLD: {
                    builder.clearThreshold(Integer.valueOf(value));
                    continue block12;
                }
                case BLOCK_SIZE: {
                    builder.blockSize(Integer.valueOf(value));
                    continue block12;
                }
                case CACHE_SIZE: {
                    builder.cacheSize(Long.valueOf(value));
                    continue block12;
                }
                default: {
                    Parser90.parseStoreAttribute(reader, i, builder);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case EXPIRATION: {
                    this.parseLevelDBCacheStoreExpiry(reader, builder);
                    continue block13;
                }
                case COMPRESSION: {
                    this.parseLevelDBCacheStoreCompression(reader, builder);
                    continue block13;
                }
                case IMPLEMENTATION: {
                    this.parseLevelDBCacheStoreImplementation(reader, builder);
                    continue block13;
                }
            }
            Parser90.parseStoreElement(reader, builder);
        }
    }

    private void parseLevelDBCacheStoreExpiry(XMLExtendedStreamReader reader, LevelDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeValue = reader.getAttributeValue(i);
            String value = StringPropertyReplacer.replaceProperties(attributeValue);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    builder.expiredLocation(value);
                    continue block4;
                }
                case QUEUE_SIZE: {
                    builder.expiryQueueSize(Integer.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLevelDBCacheStoreCompression(XMLExtendedStreamReader reader, LevelDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    builder.compressionType(CompressionType.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLevelDBCacheStoreImplementation(XMLExtendedStreamReader reader, LevelDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    builder.implementationType(LevelDBStoreConfiguration.ImplementationType.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

