/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import net.jcip.annotations.Immutable;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.stats.Stats;

@Immutable
public class StatsImpl
implements Stats {
    final long timeSinceReset;
    final long timeSinceStart;
    final int currentNumberOfEntries;
    final long totalNumberOfEntries;
    final long retrievals;
    final long stores;
    final long hits;
    final long misses;
    final long removeHits;
    final long removeMisses;
    final long evictions;
    final long averageReadTime;
    final long averageWriteTime;
    final long averageRemoveTime;
    final CacheMgmtInterceptor mgmtInterceptor;
    final Stats source;

    public StatsImpl(SequentialInterceptorChain chain) {
        this.mgmtInterceptor = chain.findInterceptorExtending(CacheMgmtInterceptor.class);
        this.source = null;
        if (this.mgmtInterceptor.getStatisticsEnabled()) {
            this.timeSinceReset = this.mgmtInterceptor.getTimeSinceReset();
            this.timeSinceStart = this.mgmtInterceptor.getTimeSinceStart();
            this.currentNumberOfEntries = this.mgmtInterceptor.getNumberOfEntries();
            this.totalNumberOfEntries = this.mgmtInterceptor.getStores();
            this.retrievals = this.mgmtInterceptor.getHits() + this.mgmtInterceptor.getMisses();
            this.stores = this.mgmtInterceptor.getStores();
            this.hits = this.mgmtInterceptor.getHits();
            this.misses = this.mgmtInterceptor.getMisses();
            this.removeHits = this.mgmtInterceptor.getRemoveHits();
            this.removeMisses = this.mgmtInterceptor.getRemoveMisses();
            this.evictions = this.mgmtInterceptor.getEvictions();
            this.averageReadTime = this.mgmtInterceptor.getAverageReadTime();
            this.averageWriteTime = this.mgmtInterceptor.getAverageWriteTime();
            this.averageRemoveTime = this.mgmtInterceptor.getAverageRemoveTime();
        } else {
            this.timeSinceReset = -1L;
            this.timeSinceStart = -1L;
            this.currentNumberOfEntries = -1;
            this.totalNumberOfEntries = -1L;
            this.retrievals = -1L;
            this.stores = -1L;
            this.hits = -1L;
            this.misses = -1L;
            this.removeHits = -1L;
            this.removeMisses = -1L;
            this.evictions = -1L;
            this.averageReadTime = -1L;
            this.averageWriteTime = -1L;
            this.averageRemoveTime = -1L;
        }
    }

    public StatsImpl(Stats other) {
        this.mgmtInterceptor = null;
        this.source = other;
        if (other != null) {
            this.timeSinceReset = other.getTimeSinceReset();
            this.timeSinceStart = other.getTimeSinceStart();
            this.currentNumberOfEntries = other.getCurrentNumberOfEntries();
            this.totalNumberOfEntries = other.getTotalNumberOfEntries();
            this.retrievals = other.getRetrievals();
            this.stores = other.getStores();
            this.hits = other.getHits();
            this.misses = other.getMisses();
            this.removeHits = other.getRemoveHits();
            this.removeMisses = other.getRemoveMisses();
            this.evictions = other.getEvictions();
            this.averageReadTime = other.getAverageReadTime();
            this.averageWriteTime = other.getAverageWriteTime();
            this.averageRemoveTime = other.getAverageRemoveTime();
        } else {
            this.timeSinceReset = -1L;
            this.timeSinceStart = -1L;
            this.currentNumberOfEntries = -1;
            this.totalNumberOfEntries = -1L;
            this.retrievals = -1L;
            this.stores = -1L;
            this.hits = -1L;
            this.misses = -1L;
            this.removeHits = -1L;
            this.removeMisses = -1L;
            this.evictions = -1L;
            this.averageReadTime = -1L;
            this.averageWriteTime = -1L;
            this.averageRemoveTime = -1L;
        }
    }

    @Override
    public long getTimeSinceStart() {
        return this.timeSinceStart;
    }

    @Override
    public long getTimeSinceReset() {
        return this.timeSinceReset;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.currentNumberOfEntries;
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.totalNumberOfEntries;
    }

    @Override
    public long getRetrievals() {
        return this.retrievals;
    }

    @Override
    public long getStores() {
        return this.stores;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    @Override
    public long getRemoveHits() {
        return this.removeHits;
    }

    @Override
    public long getRemoveMisses() {
        return this.removeMisses;
    }

    @Override
    public long getEvictions() {
        return this.evictions;
    }

    @Override
    public long getAverageReadTime() {
        return this.averageReadTime;
    }

    @Override
    public long getAverageWriteTime() {
        return this.averageWriteTime;
    }

    @Override
    public long getAverageRemoveTime() {
        return this.averageRemoveTime;
    }

    @Override
    public void reset() {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.resetStatistics();
        } else if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.setStatisticsEnabled(enabled);
        } else if (this.source != null) {
            this.source.setStatisticsEnabled(enabled);
        }
    }
}

