/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.intops.UnorderedOperation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractLocalCacheStream<T, S extends BaseStream<T, S>, S2 extends S>
implements BaseStream<T, S> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final StreamSupplier<T> streamSupplier;
    protected final ComponentRegistry registry;
    protected final Collection<Runnable> onCloseRunnables;
    protected final Queue<IntermediateOperation> intermediateOperations;
    protected Set<Integer> segmentsToFilter;
    protected Set<?> keysToFilter;
    protected boolean parallel;

    public AbstractLocalCacheStream(StreamSupplier<T> streamSupplier, boolean parallel, ComponentRegistry registry) {
        this.streamSupplier = streamSupplier;
        this.registry = registry;
        this.onCloseRunnables = new ArrayList<Runnable>(4);
        this.intermediateOperations = new ArrayDeque<IntermediateOperation>();
        this.parallel = parallel;
    }

    AbstractLocalCacheStream(AbstractLocalCacheStream<?, ?, ?> original) {
        this.streamSupplier = original.streamSupplier;
        this.registry = original.registry;
        this.onCloseRunnables = original.onCloseRunnables;
        this.intermediateOperations = original.intermediateOperations;
        this.segmentsToFilter = original.segmentsToFilter;
        this.keysToFilter = original.keysToFilter;
        this.parallel = original.parallel;
    }

    protected final S createStream() {
        Stream<Object> stream = this.streamSupplier.buildStream(this.segmentsToFilter, this.keysToFilter);
        if (this.parallel) {
            stream = stream.parallel();
        }
        for (IntermediateOperation intOp : this.intermediateOperations) {
            stream = intOp.perform(stream);
        }
        return (S)stream;
    }

    @Override
    public boolean isParallel() {
        return this.createStream().isParallel();
    }

    @Override
    public S2 sequential() {
        this.parallel = false;
        return (S2)this;
    }

    @Override
    public S2 parallel() {
        this.parallel = true;
        return (S2)this;
    }

    @Override
    public S2 unordered() {
        this.intermediateOperations.add(new UnorderedOperation());
        return (S2)this;
    }

    @Override
    public S2 onClose(Runnable closeHandler) {
        this.onCloseRunnables.add(closeHandler);
        return (S2)this;
    }

    @Override
    public void close() {
        this.onCloseRunnables.forEach(Runnable::run);
    }

    public static interface StreamSupplier<R> {
        public Stream<R> buildStream(Set<Integer> var1, Set<?> var2);

        public CloseableIterator<R> removableIterator(CloseableIterator<R> var1);
    }
}

