/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistentUUIDManagerImpl
implements PersistentUUIDManager {
    private static final Log log = LogFactory.getLog(PersistentUUIDManagerImpl.class);
    private final EquivalentConcurrentHashMapV8<Address, PersistentUUID> address2uuid = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
    private final EquivalentConcurrentHashMapV8<PersistentUUID, Address> uuid2address = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());

    @Override
    public void addPersistentAddressMapping(Address address, PersistentUUID persistentUUID) {
        this.address2uuid.put(address, persistentUUID);
        this.uuid2address.put(persistentUUID, address);
    }

    @Override
    public PersistentUUID getPersistentUuid(Address address) {
        return this.address2uuid.get(address);
    }

    @Override
    public Address getAddress(PersistentUUID persistentUUID) {
        return this.uuid2address.get(persistentUUID);
    }

    @Override
    public void removePersistentAddressMapping(PersistentUUID persistentUUID) {
        Address address = this.uuid2address.get(persistentUUID);
        if (address != null) {
            this.address2uuid.remove(address);
            this.uuid2address.remove(persistentUUID);
        }
    }

    @Override
    public void removePersistentAddressMapping(Address address) {
        PersistentUUID uuid = this.address2uuid.get(address);
        if (uuid != null) {
            this.uuid2address.remove(uuid);
            this.address2uuid.remove(address);
        }
    }

    @Override
    public List<PersistentUUID> mapAddresses(List<Address> addresses) {
        ArrayList<PersistentUUID> list = new ArrayList<PersistentUUID>(addresses.size());
        for (Address address : addresses) {
            PersistentUUID persistentUUID = this.address2uuid.get(address);
            if (persistentUUID == null) {
                NullPointerException npe = new NullPointerException();
                log.fatal("Cannot find mapping for address " + address, npe);
                throw npe;
            }
            list.add(persistentUUID);
        }
        return list;
    }

    @Override
    public UnaryOperator<Address> addressToPersistentUUID() {
        return address -> this.address2uuid.get(address);
    }

    @Override
    public UnaryOperator<Address> persistentUUIDToAddress() {
        return address -> this.uuid2address.get(address);
    }
}

