/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.TransactionManager;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class XSiteStateConsumerImpl
implements XSiteStateConsumer {
    private static final long STATE_TRANSFER_PUT_FLAGS = EnumUtil.bitSetOf(Flag.PUT_FOR_X_SITE_STATE_TRANSFER, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_XSITE_BACKUP);
    private static final Log log = LogFactory.getLog(XSiteStateConsumerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean debug = log.isDebugEnabled();
    private TransactionManager transactionManager;
    private InvocationContextFactory invocationContextFactory;
    private CommandsFactory commandsFactory;
    private InterceptorChain interceptorChain;
    private CommitManager commitManager;
    private AtomicReference<String> sendingSite = new AtomicReference<Object>(null);

    @Inject
    public void inject(TransactionManager transactionManager, InvocationContextFactory invocationContextFactory, CommandsFactory commandsFactory, InterceptorChain interceptorChain, CommitManager commitManager) {
        this.transactionManager = transactionManager;
        this.invocationContextFactory = invocationContextFactory;
        this.commandsFactory = commandsFactory;
        this.interceptorChain = interceptorChain;
        this.commitManager = commitManager;
    }

    @Override
    public void startStateTransfer(String sendingSite) {
        if (debug) {
            log.debugf("Starting state transfer. Receiving from %s", (Object)sendingSite);
        }
        if (!this.sendingSite.compareAndSet(null, sendingSite)) {
            throw new CacheException("Already receiving state from " + this.sendingSite.get());
        }
        this.commitManager.startTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
    }

    @Override
    public void endStateTransfer(String sendingSite) {
        if (debug) {
            log.debugf("Ending state transfer from %s", (Object)sendingSite);
        }
        String currentSendingSite = this.sendingSite.get();
        if (sendingSite == null || sendingSite.equals(currentSendingSite)) {
            this.sendingSite.set(null);
            this.commitManager.stopTrack(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        } else if (log.isDebugEnabled()) {
            log.debugf("Received an end request from a non-sender site. Expects %s but got %s", (Object)currentSendingSite, (Object)sendingSite);
        }
    }

    @Override
    public void applyState(XSiteState[] chunk) throws Exception {
        if (debug) {
            log.debugf("Received state: %s keys", chunk.length);
        }
        if (this.transactionManager != null) {
            this.applyStateInTransaction(chunk);
        } else {
            this.applyStateInNonTransaction(chunk);
        }
    }

    @Override
    public String getSendingSiteName() {
        return this.sendingSite.get();
    }

    private void applyStateInTransaction(XSiteState[] chunk) throws Exception {
        try {
            this.transactionManager.begin();
            InvocationContext ctx = this.invocationContextFactory.createInvocationContext(this.transactionManager.getTransaction(), true);
            ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            for (XSiteState siteState : chunk) {
                this.interceptorChain.invoke(ctx, this.createPut(siteState));
                if (!trace) continue;
                log.tracef("Successfully applied key'%s'", (Object)siteState);
            }
            this.transactionManager.commit();
            if (debug) {
                log.debugf("Successfully applied state. %s keys inserted", chunk.length);
            }
        }
        catch (Exception e) {
            log.unableToApplyXSiteState(e);
            this.safeRollback();
            throw e;
        }
    }

    private void applyStateInNonTransaction(XSiteState[] chunk) {
        SingleKeyNonTxInvocationContext ctx = (SingleKeyNonTxInvocationContext)this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        for (XSiteState siteState : chunk) {
            PutKeyValueCommand command = this.createPut(siteState);
            ctx.setLockOwner(command.getKeyLockOwner());
            this.interceptorChain.invoke(ctx, command);
            ctx.resetState();
            if (!trace) continue;
            log.tracef("Successfully applied key'%s'", (Object)siteState);
        }
        if (debug) {
            log.debugf("Successfully applied state. %s keys inserted", chunk.length);
        }
    }

    private PutKeyValueCommand createPut(XSiteState state) {
        return this.commandsFactory.buildPutKeyValueCommand(state.key(), state.value(), state.metadata(), STATE_TRANSFER_PUT_FLAGS);
    }

    private void safeRollback() {
        block2: {
            try {
                this.transactionManager.rollback();
            }
            catch (Exception e) {
                if (!debug) break block2;
                log.debug("Error rollbacking transaction.", e);
            }
        }
    }
}

