/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.Version;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsImpl;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.local.ValueCacheCollection;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class CacheImpl<K, V>
implements AdvancedCache<K, V> {
    public static final String OBJECT_NAME = "Cache";
    private static final long PFER_FLAGS = EnumUtil.bitSetOf(Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ);
    protected InvocationContextContainer icc;
    protected InvocationContextFactory invocationContextFactory;
    protected CommandsFactory commandsFactory;
    protected SequentialInterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected StreamingMarshaller marshaller;
    protected Metadata defaultMetadata;
    private final String name;
    private EvictionManager evictionManager;
    private ExpirationManager<K, V> expirationManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private EmbeddedCacheManager cacheManager;
    private LockManager lockManager;
    private DistributionManager distributionManager;
    private ExecutorService asyncExecutor;
    private TransactionTable txTable;
    private RecoveryManager recoveryManager;
    private TransactionCoordinator txCoordinator;
    private AuthorizationManager authorizationManager;
    private PartitionHandlingManager partitionHandlingManager;
    private GlobalConfiguration globalCfg;
    private boolean isClassLoaderInContext;
    private LocalTopologyManager localTopologyManager;
    private volatile boolean stopping = false;

    public CacheImpl(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, ExpirationManager expirationManager, InvocationContextFactory invocationContextFactory, InvocationContextContainer icc, CommandsFactory commandsFactory, SequentialInterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, DistributionManager distributionManager, EmbeddedCacheManager cacheManager, @ComponentName(value="org.infinispan.executors.async") ExecutorService asyncExecutor, TransactionTable txTable, RecoveryManager recoveryManager, TransactionCoordinator txCoordinator, LockManager lockManager, AuthorizationManager authorizationManager, GlobalConfiguration globalCfg, PartitionHandlingManager partitionHandlingManager, LocalTopologyManager localTopologyManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.expirationManager = expirationManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.invocationContextFactory = invocationContextFactory;
        this.icc = icc;
        this.distributionManager = distributionManager;
        this.asyncExecutor = asyncExecutor;
        this.txTable = txTable;
        this.recoveryManager = recoveryManager;
        this.txCoordinator = txCoordinator;
        this.lockManager = lockManager;
        this.authorizationManager = authorizationManager;
        this.globalCfg = globalCfg;
        this.partitionHandlingManager = partitionHandlingManager;
        this.localTopologyManager = localTopologyManager;
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.config.expiration().lifespan()).maxIdle(this.config.expiration().maxIdle()).build();
    }

    private void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    private void assertKeyValueNotNull(Object key, Object value) {
        this.assertKeyNotNull(key);
        if (value == null) {
            throw new NullPointerException("Null values are not supported!");
        }
    }

    private void assertValueNotNull(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values are not supported!");
        }
    }

    @Override
    public final V put(K key, V value) {
        return this.put(key, value, this.defaultMetadata);
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultMetadata);
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultMetadata);
    }

    @Override
    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultMetadata);
    }

    @Override
    public final CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultMetadata);
    }

    @Override
    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultMetadata, 0L, null);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, TimeUnit.MILLISECONDS, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultMetadata, 0L, null);
    }

    @Override
    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultMetadata, 0L, (ClassLoader)null);
    }

    @Override
    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultMetadata, 0L, null);
    }

    @Override
    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.defaultMetadata, 0L, null);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, 0L, null);
    }

    @Deprecated
    final boolean remove(Object key, Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.remove(key, value, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final boolean remove(Object key, Object value, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.removeInternal(key, value, explicitFlags, ctx);
    }

    private boolean removeInternal(Object key, Object value, long explicitFlags, InvocationContext ctx) {
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, explicitFlags);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public final int size() {
        return this.size(null, null);
    }

    final int size(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        SizeCommand command = this.commandsFactory.buildSizeCommand(explicitFlags);
        return (Integer)this.invoker.invoke(this.getInvocationContextForRead(explicitClassLoader, -1), command);
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty(null, null);
    }

    final boolean isEmpty(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return !this.entrySet(explicitFlags, explicitClassLoader).stream().anyMatch(StreamMarshalling.alwaysTruePredicate());
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey(key, 0L, null);
    }

    @Deprecated
    final boolean containsKey(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.containsKey(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final boolean containsKey(Object key, long explicitFlags, ClassLoader explicitClassLoader) {
        return this.get(key, explicitFlags, explicitClassLoader) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        this.assertValueNotNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    @Override
    public final V get(Object key) {
        return this.get(key, 0L, null);
    }

    @Deprecated
    final V get(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.get(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final V get(Object key, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, 1);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, explicitFlags);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Deprecated
    public final CacheEntry getCacheEntry(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.getCacheEntry(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CacheEntry getCacheEntry(Object key, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, 1);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, explicitFlags);
        Object ret = this.invoker.invoke(ctx, command);
        return (CacheEntry)ret;
    }

    @Override
    public final CacheEntry getCacheEntry(Object key) {
        return this.getCacheEntry(key, 0L, null);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.getAll(keys, 0L, null);
    }

    @Deprecated
    public final Map<K, V> getAll(Set<?> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.getAll(keys, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final Map<K, V> getAll(Set<?> keys, long explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, keys.size());
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        Map map = (Map)this.invoker.invoke(ctx, command);
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.getAllCacheEntries(keys, null, null);
    }

    public final Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, keys.size());
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, EnumUtil.bitSetOf(explicitFlags), true);
        Map map = (Map)this.invoker.invoke(ctx, command);
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.getGroup(groupName, 0L, null);
    }

    @Deprecated
    protected final Map<K, V> getGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.getGroup(groupName, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final Map<K, V> getGroup(String groupName, long explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        return Collections.unmodifiableMap(this.internalGetGroup(groupName, explicitFlags, ctx));
    }

    private Map<K, V> internalGetGroup(String groupName, long explicitFlagsBitSet, InvocationContext ctx) {
        GetKeysInGroupCommand command = this.commandsFactory.buildGetKeysInGroupCommand(explicitFlagsBitSet, groupName);
        return (Map)this.invoker.invoke(ctx, command);
    }

    @Override
    public void removeGroup(String groupName) {
        this.removeGroup(groupName, 0L, null);
    }

    @Deprecated
    protected final void removeGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.removeGroup(groupName, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final void removeGroup(String groupName, long explicitFlags, ClassLoader explicitClassLoader) {
        if (this.transactionManager == null) {
            this.nonTransactionalRemoveGroup(groupName, explicitFlags, explicitClassLoader);
        } else {
            this.transactionalRemoveGroup(groupName, explicitFlags, explicitClassLoader);
        }
    }

    private void transactionalRemoveGroup(String groupName, long explicitFlagsBitSet, ClassLoader explicitClassLoader) {
        boolean onGoingTransaction;
        boolean bl = onGoingTransaction = this.getOngoingTransaction() != null;
        if (!onGoingTransaction) {
            this.tryBegin();
        }
        try {
            InvocationContext context = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, -1);
            Map<K, V> keys = this.internalGetGroup(groupName, explicitFlagsBitSet, context);
            long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlagsBitSet);
            for (K key : keys.keySet()) {
                this.removeInternal(key, removeFlags, context);
            }
            if (!onGoingTransaction) {
                this.tryCommit();
            }
        }
        catch (RuntimeException e) {
            if (!onGoingTransaction) {
                this.tryRollback();
            }
            throw e;
        }
    }

    private void nonTransactionalRemoveGroup(String groupName, long explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext context = this.getInvocationContextForRead(explicitClassLoader, -1);
        Map<K, V> keys = this.internalGetGroup(groupName, explicitFlags, context);
        long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlags);
        for (K key : keys.keySet()) {
            this.assertKeyNotNull(key);
            InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
            this.removeInternal(key, removeFlags, ctx);
        }
    }

    @Override
    public final V remove(Object key) {
        return this.remove(key, 0L, null);
    }

    @Deprecated
    final V remove(Object key, Set<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.remove(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final V remove(Object key, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.removeInternal(key, explicitFlags, ctx);
    }

    private V removeInternal(Object key, long explicitFlags, InvocationContext ctx) {
        long flags = this.addUnsafeFlags(explicitFlags);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, flags);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, null, 1);
        RemoveExpiredCommand command = this.commandsFactory.buildRemoveExpiredCommand(key, value, lifespan);
        ctx.setLockOwner(command.getKeyLockOwner());
        this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public final void clearOperation() {
        this.clear(0L, null);
    }

    @Override
    public final void clear() {
        this.clear(0L, null);
    }

    @Deprecated
    final void clear(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.clear(EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clear(long explicitFlags, ClassLoader explicitClassLoader) {
        Transaction tx = this.suspendOngoingTransactionIfExists();
        try {
            InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
            this.setInvocationContextClassLoader(context, explicitClassLoader);
            ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
            this.invoker.invoke(context, command);
        }
        finally {
            this.resumePreviousOngoingTransaction(tx, true, "Had problems trying to resume a transaction after clear()");
        }
    }

    @Override
    public CacheSet<K> keySet() {
        return this.keySet(null, null);
    }

    CacheSet<K> keySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        KeySetCommand command = this.commandsFactory.buildKeySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public CacheCollection<V> values() {
        return this.values(null, null);
    }

    CacheCollection<V> values(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet(explicitFlags, explicitClassLoader));
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheEntrySet(null, null);
    }

    CacheSet<CacheEntry<K, V>> cacheEntrySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null, null);
    }

    CacheSet<Map.Entry<K, V>> entrySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, 0L, (ClassLoader)null);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        this.putForExternalRead(key, value, lifespan, lifespanUnit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        this.putForExternalRead(key, value, merged, 0L, null);
    }

    @Deprecated
    final void putForExternalRead(K key, V value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.putForExternalRead(key, value, this.defaultMetadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final void putForExternalRead(K key, V value, long explicitFlags, ClassLoader explicitClassLoader) {
        this.putForExternalRead(key, value, this.defaultMetadata, explicitFlags, explicitClassLoader);
    }

    @Deprecated
    final void putForExternalRead(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.putForExternalRead(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putForExternalRead(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            this.putIfAbsent(key, value, metadata, EnumUtil.mergeBitSets(PFER_FLAGS, explicitFlags), explicitClassLoader);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, true, "Had problems trying to resume a transaction after putForExternalRead()");
        }
    }

    @Override
    public final void evict(K key) {
        this.evict(key, 0L, null);
    }

    @Deprecated
    final void evict(K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.evict(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final void evict(K key, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.createSingleKeyNonTxInvocationContext(explicitClassLoader);
        EvictCommand command = this.commandsFactory.buildEvictCommand(key, explicitFlags);
        this.invoker.invoke(ctx, command);
    }

    private InvocationContext createSingleKeyNonTxInvocationContext(ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.notifier.addListener(listener, filter);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.notifier.addListener(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContextForWrite(ClassLoader explicitClassLoader, int keyCount, boolean isPutForExternalRead) {
        InvocationContext ctx = isPutForExternalRead ? this.invocationContextFactory.createSingleKeyNonTxInvocationContext() : this.invocationContextFactory.createInvocationContext(true, keyCount);
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    private InvocationContext getInvocationContextForRead(ClassLoader explicitClassLoader, int keyCount) {
        Transaction transaction;
        if (this.config.transaction().transactionMode().isTransactional() && (transaction = this.getOngoingTransaction()) != null) {
            return this.getInvocationContext(transaction, explicitClassLoader, false);
        }
        InvocationContext result = this.invocationContextFactory.createInvocationContext(false, keyCount);
        this.setInvocationContextClassLoader(result, explicitClassLoader);
        return result;
    }

    private InvocationContext getInvocationContextWithImplicitTransactionForAsyncOps(boolean isPutForExternalRead, ClassLoader explicitClassLoader, int keyCount) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(isPutForExternalRead, explicitClassLoader, keyCount);
        try {
            if (this.isTxInjected(ctx)) {
                this.transactionManager.suspend();
            }
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
        return ctx;
    }

    private InvocationContext getInvocationContextWithImplicitTransaction(boolean isPutForExternalRead, ClassLoader explicitClassLoader, int keyCount) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.config.transaction().transactionMode().isTransactional() && !isPutForExternalRead) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.config.transaction().autoCommit()) {
                transaction = this.tryBegin();
                txInjected = true;
            }
            invocationContext = this.getInvocationContext(transaction, explicitClassLoader, txInjected);
        } else {
            invocationContext = this.getInvocationContextForWrite(explicitClassLoader, keyCount, isPutForExternalRead);
        }
        return invocationContext;
    }

    private InvocationContext getInvocationContext(Transaction tx, ClassLoader explicitClassLoader, boolean implicitTransaction) {
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(tx, implicitTransaction);
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    private InvocationContext setInvocationContextClassLoader(InvocationContext ctx, ClassLoader explicitClassLoader) {
        if (this.isClassLoaderInContext) {
            ctx.setClassLoader(explicitClassLoader != null ? explicitClassLoader : this.getClassLoader());
        }
        return ctx;
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertKeyNotNull(keys);
        return this.lock(Arrays.asList(keys), 0L, null);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.lock(keys, 0L, null);
    }

    @Deprecated
    boolean lock(Collection<? extends K> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.lock(keys, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    boolean lock(Collection<? extends K> keys, long flagsBitSet, ClassLoader explicitClassLoader) {
        if (!this.config.transaction().transactionMode().isTransactional()) {
            throw new UnsupportedOperationException("Calling lock() on non-transactional caches is not allowed");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(explicitClassLoader, -1, false);
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, flagsBitSet);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        if (locksToAcquire == null || locksToAcquire.length == 0) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(null, -1, false);
        ApplyDeltaCommand command = this.commandsFactory.buildApplyDeltaCommand(deltaAwareValueKey, delta, Arrays.asList(locksToAcquire));
        ctx.setLockOwner(command.getKeyLockOwner());
        this.invoker.invoke(ctx, command);
    }

    @Override
    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        boolean bl = this.isClassLoaderInContext = this.config.clustering().cacheMode().isClustered() || this.config.persistence().usingStores() || this.config.storeAsBinary().enabled();
        if (log.isDebugEnabled()) {
            log.debugf("Started cache %s on %s", (Object)this.getName(), (Object)this.getCacheManager().getAddress());
        }
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.performImmediateShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debugf("Shutting down cache %s on %s", (Object)this.getName(), (Object)this.getCacheManager().getAddress());
        }
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            if (!this.stopping && this.componentRegistry.getStatus() == ComponentStatus.RUNNING) {
                this.stopping = true;
                this.requestClusterWideShutdown();
            }
        }
    }

    private void requestClusterWideShutdown() {
        if (this.config.clustering().cacheMode().isClustered()) {
            try {
                this.localTopologyManager.cacheShutdown(this.name);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
        this.performImmediateShutdown();
    }

    private void performImmediateShutdown() {
        if (log.isDebugEnabled()) {
            log.debugf("Stopping cache %s on %s", (Object)this.getName(), (Object)this.getCacheManager().getAddress());
        }
        this.componentRegistry.stop();
    }

    public void performGracefulShutdown() {
        PassivationManager passivationManager = this.componentRegistry.getComponent(PassivationManager.class);
        if (passivationManager != null) {
            passivationManager.passivateAll();
        }
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        List<SequentialInterceptor> interceptors = this.invoker.getInterceptors();
        ArrayList<CommandInterceptor> list = new ArrayList<CommandInterceptor>(interceptors.size());
        interceptors.forEach((? super T interceptor) -> {
            if (interceptor instanceof CommandInterceptor) {
                list.add((CommandInterceptor)interceptor);
            }
        });
        return list;
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public SequentialInterceptorChain getSequentialInterceptorChain() {
        return this.invoker;
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        return this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        return this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.partitionHandlingManager.getAvailabilityMode();
    }

    @Override
    public void setAvailability(AvailabilityMode availability) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheAvailability(this.getName(), availability);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    public void setCacheAvailability(String availabilityString) throws Exception {
        this.setAvailability(AvailabilityMode.valueOf(availabilityString));
    }

    @ManagedAttribute(description="Returns whether cache rebalancing is enabled", displayName="Cache rebalacing", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        if (this.localTopologyManager != null) {
            try {
                return this.localTopologyManager.isCacheRebalancingEnabled(this.getName());
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
        return false;
    }

    public void setRebalancingEnabled(boolean enabled) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheRebalancingEnabled(this.getName(), enabled);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
    }

    @Override
    public boolean startBatch() {
        if (!this.config.invocationBatching().enabled()) {
            throw log.invocationBatchingNotEnabled();
        }
        return this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.config.invocationBatching().enabled()) {
            throw log.invocationBatchingNotEnabled();
        }
        this.batchContainer.endBatch(successful);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @Override
    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return Version.getVersion();
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config != null && this.config.clustering().cacheMode().isClustered() ? this.getCacheManager().getAddress() : Util.hexIdHashCode(this.getCacheManager()));
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.icc;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return new StatsImpl(this.invoker);
    }

    @Override
    public XAResource getXAResource() {
        return new TransactionXaAdapter(this.txTable, this.recoveryManager, this.txCoordinator, this.commandsFactory, this.rpcManager, null, this.config, this.name, this.partitionHandlingManager);
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.put(key, value, metadata, 0L, null);
    }

    @Deprecated
    final V put(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.put(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final V put(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.putInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V putInternal(K key, V value, Metadata metadata, long explicitFlags, InvocationContext ctx) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, merged, flags);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    private long addIgnoreReturnValuesFlag(long flagBitSet) {
        return EnumUtil.setEnum(flagBitSet, Flag.IGNORE_RETURN_VALUES);
    }

    private long addUnsafeFlags(long flagBitSet) {
        return this.config.unsafe().unreliableReturnValues() ? this.addIgnoreReturnValuesFlag(flagBitSet) : flagBitSet;
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.putIfAbsent(key, value, metadata, 0L, null);
    }

    @Deprecated
    final V putIfAbsent(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.putIfAbsent(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final V putIfAbsent(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(EnumUtil.hasEnum(explicitFlags, Flag.PUT_FOR_EXTERNAL_READ), explicitClassLoader, 1);
        return this.putIfAbsentInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V putIfAbsentInternal(K key, V value, Metadata metadata, long explicitFlags, InvocationContext ctx) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, merged, flags);
        command.setPutIfAbsent(true);
        command.setValueMatcher(ValueMatcher.MATCH_EXPECTED);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putAll(map, metadata, 0L, null);
    }

    @Deprecated
    final void putAll(Map<? extends K, ? extends V> map, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.putAll(map, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final void putAll(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, map.size());
        this.putAllInternal(map, metadata, explicitFlags, ctx);
    }

    private void putAllInternal(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, InvocationContext ctx) {
        InfinispanCollections.assertNotNullEntries(map, "map");
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, merged, explicitFlags);
        ctx.setLockOwner(command.getKeyLockOwner());
        this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, value, metadata, 0L, (ClassLoader)null);
    }

    @Deprecated
    final V replace(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.replace(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final V replace(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.replaceInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V replaceInternal(K key, V value, Metadata metadata, long explicitFlags, InvocationContext ctx) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, merged, flags);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, oldValue, value, metadata, 0L, null);
    }

    @Deprecated
    final boolean replace(K key, V oldValue, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.replace(key, oldValue, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final boolean replace(K key, V oldValue, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        this.assertValueNotNull(oldValue);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.replaceInternal(key, oldValue, value, metadata, explicitFlags, ctx);
    }

    private boolean replaceInternal(K key, V oldValue, V value, Metadata metadata, long explicitFlags, InvocationContext ctx) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, value, merged, explicitFlags);
        ctx.setLockOwner(command.getKeyLockOwner());
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    private <X> CompletableFuture<X> wrapInFuture(Object retval) {
        if (retval instanceof CompletableFuture) {
            return (CompletableFuture)retval;
        }
        return CompletableFuture.completedFuture(retval);
    }

    @Override
    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata, 0L, null);
    }

    @Deprecated
    final CompletableFuture<V> putAsync(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.putAsync(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<V> putAsync(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.putInternal(key, value, metadata, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(data, metadata, 0L, null);
    }

    @Deprecated
    final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.putAllAsync(data, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, data.size());
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            this.putAllInternal(data, metadata, explicitFlags, ctx);
            return null;
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<Void> clearAsync() {
        return this.clearAsync(0L, null);
    }

    @Deprecated
    final CompletableFuture<Void> clearAsync(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.clearAsync(EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<Void> clearAsync(long explicitFlags, ClassLoader explicitClassLoader) {
        return CompletableFuture.supplyAsync(() -> {
            this.clear(explicitFlags, explicitClassLoader);
            return null;
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata, 0L, null);
    }

    @Deprecated
    final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.putIfAbsentAsync(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.putIfAbsentInternal(key, value, metadata, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<V> removeAsync(Object key) {
        return this.removeAsync(key, 0L, null);
    }

    @Deprecated
    final CompletableFuture<V> removeAsync(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.removeAsync(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<V> removeAsync(Object key, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.removeInternal(key, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.removeAsync(key, value, 0L, null);
    }

    @Deprecated
    final CompletableFuture<Boolean> removeAsync(Object key, Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.removeAsync(key, value, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<Boolean> removeAsync(Object key, Object value, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.removeInternal(key, value, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, metadata, 0L, (ClassLoader)null);
    }

    @Deprecated
    final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.replaceAsync(key, value, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, value);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.replaceInternal(key, value, metadata, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, oldValue, newValue, metadata, 0L, null);
    }

    @Deprecated
    final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.replaceAsync(key, oldValue, newValue, metadata, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata, long explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyValueNotNull(key, newValue);
        this.assertValueNotNull(oldValue);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.associateImplicitTransactionWithCurrentThread(ctx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CompletionException(e);
            }
            return this.replaceInternal(key, oldValue, newValue, metadata, explicitFlags, ctx);
        }, this.asyncExecutor);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, 0L, null);
    }

    @Deprecated
    CompletableFuture<V> getAsync(K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.getAsync(key, EnumUtil.bitSetOf(explicitFlags), explicitClassLoader);
    }

    CompletableFuture<V> getAsync(K key, long explicitFlags, ClassLoader explicitClassLoader) {
        if (this.asyncSkipsThread(explicitFlags, key)) {
            return this.wrapInFuture(this.get(key, explicitFlags, explicitClassLoader));
        }
        return CompletableFuture.supplyAsync(() -> this.get(key, explicitFlags, explicitClassLoader), this.asyncExecutor);
    }

    private boolean asyncSkipsThread(EnumSet<Flag> flags, K key) {
        boolean isSkipLoader = this.isSkipLoader(flags);
        if (!isSkipLoader) {
            return false;
        }
        if (!this.config.clustering().cacheMode().isDistributed()) {
            return true;
        }
        if (flags != null && (flags.contains((Object)Flag.SKIP_REMOTE_LOOKUP) || flags.contains((Object)Flag.CACHE_MODE_LOCAL))) {
            return true;
        }
        return this.distributionManager.getLocality(key).isLocal();
    }

    private boolean asyncSkipsThread(long flags, K key) {
        if (!this.isSkipLoader(flags)) {
            return false;
        }
        if (!this.config.clustering().cacheMode().isDistributed()) {
            return true;
        }
        if (EnumUtil.hasEnum(flags, Flag.SKIP_REMOTE_LOOKUP) || EnumUtil.hasEnum(flags, Flag.CACHE_MODE_LOCAL)) {
            return true;
        }
        return this.distributionManager.getLocality(key).isLocal();
    }

    private boolean isSkipLoader(EnumSet<Flag> flags) {
        boolean hasCacheLoaderConfig = !this.config.persistence().stores().isEmpty();
        return !hasCacheLoaderConfig || flags != null && (flags.contains((Object)Flag.SKIP_CACHE_LOAD) || flags.contains((Object)Flag.SKIP_CACHE_STORE));
    }

    private boolean isSkipLoader(long flags) {
        boolean hasCacheLoaderConfig = !this.config.persistence().stores().isEmpty();
        return !hasCacheLoaderConfig || EnumUtil.hasEnum(flags, Flag.SKIP_CACHE_LOAD) || EnumUtil.hasEnum(flags, Flag.SKIP_CACHE_STORE);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        return new DecoratedCache(this, flags);
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.config.invocationBatching().enabled()) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", e);
        }
    }

    private Object executeCommandAndCommitIfNeeded(InvocationContext ctx, VisitableCommand command) {
        Object result;
        boolean txInjected = this.isTxInjected(ctx);
        try {
            result = this.invoker.invoke(ctx, command);
        }
        catch (Throwable e) {
            if (txInjected) {
                this.tryRollback();
            }
            throw e;
        }
        if (txInjected) {
            this.tryCommit();
        }
        return result;
    }

    private boolean isTxInjected(InvocationContext ctx) {
        return ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
    }

    private Transaction tryBegin() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            this.transactionManager.begin();
            Transaction transaction = this.getOngoingTransaction();
            if (trace) {
                log.tracef("Implicit transaction started! Transaction: %s", (Object)transaction);
            }
            return transaction;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException("Unable to begin implicit transaction.", e);
        }
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!trace) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    private void tryCommit() {
        if (this.transactionManager == null) {
            return;
        }
        if (trace) {
            log.tracef("Committing transaction as it was implicit: %s", (Object)this.getOngoingTransaction());
        }
        try {
            this.transactionManager.commit();
        }
        catch (Throwable e) {
            log.couldNotCompleteInjectedTransaction(e);
            throw new CacheException("Could not commit implicit transaction", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.globalCfg.classLoader();
        return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new DecoratedCache(this, classLoader);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.put(key, value, metadata, 0L, null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAll(map, metadata, 0L, null);
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        if (metadata == null) {
            return this.defaultMetadata;
        }
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.replace(key, value, metadata, 0L, (ClassLoader)null);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.replace(key, oldValue, value, metadata, 0L, null);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.putIfAbsent(key, value, metadata, 0L, null);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.putAsync(key, value, metadata, 0L, null);
    }

    private void associateImplicitTransactionWithCurrentThread(InvocationContext ctx) throws InvalidTransactionException, SystemException {
        if (this.isTxInjected(ctx)) {
            Transaction transaction = ((TxInvocationContext)ctx).getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("Null transaction not possible!");
            }
            this.transactionManager.resume(transaction);
        }
    }

    private Transaction suspendOngoingTransactionIfExists() {
        Transaction tx = this.getOngoingTransaction();
        if (tx != null) {
            try {
                this.transactionManager.suspend();
            }
            catch (SystemException e) {
                throw new CacheException("Unable to suspend transaction.", e);
            }
        }
        return tx;
    }

    private void resumePreviousOngoingTransaction(Transaction transaction, boolean failSilently, String failMessage) {
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (failSilently) {
                    if (log.isDebugEnabled()) {
                        log.debug(failMessage);
                    }
                }
                throw new CacheException(failMessage, e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.config);
    }
}

