/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvalidateCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 6;
    private static final Log log = LogFactory.getLog(InvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object[] keys;

    public InvalidateCommand() {
        this.valueMatcher = ValueMatcher.MATCH_ALWAYS;
    }

    public InvalidateCommand(CacheNotifier notifier, long flagsBitSet, CommandInvocationId commandInvocationId, Object ... keys) {
        super(null, null, notifier, flagsBitSet, null, commandInvocationId);
        this.keys = keys;
        this.notifier = notifier;
    }

    public InvalidateCommand(CacheNotifier notifier, long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        super(null, null, notifier, flagsBitSet, null, commandInvocationId);
        this.keys = keys == null || keys.isEmpty() ? Util.EMPTY_OBJECT_ARRAY : keys.toArray(new Object[keys.size()]);
        this.notifier = notifier;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (trace) {
            log.tracef("Invalidating keys %s", (Object)Util.toStr(Arrays.asList(this.keys)));
        }
        for (Object k : this.keys) {
            this.invalidate(ctx, k);
        }
        return null;
    }

    protected void invalidate(InvocationContext ctx, Object keyToInvalidate) throws Throwable {
        this.key = keyToInvalidate;
        super.perform(ctx);
    }

    @Override
    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        this.notifier.notifyCacheEntryInvalidated(this.key, removedValue, removedMetadata, isPre, ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 6;
    }

    @Override
    public String toString() {
        return "InvalidateCommand{keys=" + Util.toStr(Arrays.asList(this.keys)) + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.commandInvocationId);
        MarshallUtil.marshallArray(this.keys, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = (CommandInvocationId)input.readObject();
        this.keys = MarshallUtil.unmarshallArray(input, Object[]::new);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    @Override
    public Object getKey() {
        throw new UnsupportedOperationException("Not supported.  Use getKeys() instead.");
    }

    public Object[] getKeys() {
        return this.keys;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return CollectionFactory.makeSet(this.keys);
    }

    @Override
    public Collection<Object> getKeysToLock() {
        return Arrays.asList(this.keys);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        InvalidateCommand that = (InvalidateCommand)o;
        return Arrays.equals(this.keys, that.keys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? Arrays.hashCode(this.keys) : 0);
        return result;
    }
}

