/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.util.Util;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;

public class InterceptorConfiguration
extends AbstractTypedPropertiesConfiguration {
    public static final AttributeDefinition<Position> POSITION = AttributeDefinition.builder("position", Position.OTHER_THAN_FIRST_OR_LAST).immutable().build();
    public static final AttributeDefinition<Class> AFTER = AttributeDefinition.builder("after", null, Class.class).immutable().build();
    public static final AttributeDefinition<Class> BEFORE = AttributeDefinition.builder("before", null, Class.class).immutable().build();
    public static final AttributeDefinition<SequentialInterceptor> INTERCEPTOR = AttributeDefinition.builder("interceptor", null, SequentialInterceptor.class).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Class> INTERCEPTOR_CLASS = AttributeDefinition.builder("interceptorClass", null, Class.class).xmlName("class").immutable().build();
    public static final AttributeDefinition<Integer> INDEX = AttributeDefinition.builder("index", -1).immutable().build();
    private final Attribute<Position> position;
    private final Attribute<Class> after;
    private final Attribute<Class> before;
    private final Attribute<SequentialInterceptor> interceptor;
    private final Attribute<Class> interceptorClass;
    private final Attribute<Integer> index;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(InterceptorConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), POSITION, AFTER, BEFORE, INTERCEPTOR, INTERCEPTOR_CLASS, INDEX);
    }

    InterceptorConfiguration(AttributeSet attributes) {
        super(attributes);
        this.position = attributes.attribute(POSITION);
        this.after = attributes.attribute(AFTER);
        this.before = attributes.attribute(BEFORE);
        this.interceptor = attributes.attribute(INTERCEPTOR);
        this.interceptorClass = attributes.attribute(INTERCEPTOR_CLASS);
        this.index = attributes.attribute(INDEX);
    }

    public Class<? extends SequentialInterceptor> after() {
        return this.after.get();
    }

    public Class<? extends SequentialInterceptor> before() {
        return this.before.get();
    }

    @Deprecated
    public CommandInterceptor interceptor() {
        if (this.interceptor.isNull()) {
            return (CommandInterceptor)Util.getInstance(this.interceptorClass.get());
        }
        return (CommandInterceptor)this.interceptor.get();
    }

    public SequentialInterceptor sequentialInterceptor() {
        if (this.interceptor.isNull()) {
            return (SequentialInterceptor)Util.getInstance(this.interceptorClass.get());
        }
        return this.interceptor.get();
    }

    @Deprecated
    public Class<? extends CommandInterceptor> interceptorClass() {
        return this.interceptorClass.get();
    }

    public Class<? extends SequentialInterceptor> sequentialInterceptorClass() {
        return this.interceptorClass.get();
    }

    public int index() {
        return this.index.get();
    }

    public Position position() {
        return this.position.get();
    }

    public boolean first() {
        return this.position() == Position.FIRST;
    }

    public boolean last() {
        return this.position() == Position.LAST;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return "InterceptorConfiguration [attributes=" + this.attributes + "]";
    }

    public static enum Position {
        FIRST,
        LAST,
        OTHER_THAN_FIRST_OR_LAST;

    }
}

