/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheWriterInterceptor
extends CacheWriterInterceptor {
    private DistributionManager dm;
    private Transport transport;
    private Address address;
    private static final Log log = LogFactory.getLog(DistCacheWriterInterceptor.class);
    private boolean isUsingLockDelegation;
    private ClusteringDependentLogic cdl;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm, Transport transport, ClusteringDependentLogic cdl) {
        this.dm = dm;
        this.transport = transport;
        this.cdl = cdl;
    }

    @Start(priority=25)
    private void setAddress() {
        this.address = this.transport.getAddress();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = ctx.forkInvocationSync(command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return ctx.shortCircuit(returnValue);
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return ctx.shortCircuit(returnValue);
        }
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return ctx.shortCircuit(returnValue);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = ctx.forkInvocationSync(command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return ctx.shortCircuit(returnValue);
        }
        Map<Object, Object> map = command.getMap();
        int count = 0;
        for (Object key : map.keySet()) {
            if (this.isUsingLockDelegation && command.isForwarded() && !this.dm.getPrimaryLocation(key).equals(ctx.getOrigin()) || !this.isProperWriter(ctx, command, key)) continue;
            this.storeEntry(ctx, key, command);
            ++count;
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(count);
        }
        return ctx.shortCircuit(returnValue);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = ctx.forkInvocationSync(command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return ctx.shortCircuit(retval);
        }
        if (!this.isProperWriter(ctx, command, key)) {
            return ctx.shortCircuit(retval);
        }
        boolean resp = this.persistenceManager.deleteFromAllStores(key, this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
        log.tracef("Removed entry under key %s and got response %s from CacheStore", key, (Object)resp);
        return ctx.shortCircuit(retval);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = ctx.forkInvocationSync(command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return ctx.shortCircuit(returnValue);
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return ctx.shortCircuit(returnValue);
        }
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return ctx.shortCircuit(returnValue);
    }

    @Override
    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !this.cdl.localNodeIsPrimaryOwner(key) || command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        if (this.isUsingLockDelegation && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && ctx.isOriginLocal() && !this.dm.getPrimaryLocation(key).equals(this.address)) {
            log.tracef("Skipping cache store on the originator because it is not the primary owner of key %s", (Object)Util.toStr(key));
            return false;
        }
        if (!this.dm.getWriteConsistentHash().isKeyLocalToNode(this.address, key)) {
            log.tracef("Skipping cache store since the key is not local: %s", key);
            return false;
        }
        return true;
    }
}

