/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.jdbc.table.management.TableName;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class OracleTableManager
extends AbstractTableManager {
    private static final Log LOG = LogFactory.getLog(OracleTableManager.class, Log.class);

    OracleTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema() == null ? metaData.getUserName() : tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef((Throwable)e, "SQLException occurs while checking the table %s", (Object)tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }
}

