/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.persistence.remote.configuration.ExhaustedAction;

public class ConnectionPoolConfiguration {
    private final ExhaustedAction exhaustedAction;
    private final int maxActive;
    private final int maxTotal;
    private final int maxIdle;
    private final int minIdle;
    private final long timeBetweenEvictionRuns;
    private final long minEvictableIdleTime;
    private final boolean testWhileIdle;

    ConnectionPoolConfiguration(ExhaustedAction exhaustedAction, int maxActive, int maxTotal, int maxIdle, int minIdle, long timeBetweenEvictionRuns, long minEvictableIdleTime, boolean testWhileIdle) {
        this.exhaustedAction = exhaustedAction;
        this.maxActive = maxActive;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        this.minEvictableIdleTime = minEvictableIdleTime;
        this.testWhileIdle = testWhileIdle;
    }

    public ExhaustedAction exhaustedAction() {
        return this.exhaustedAction;
    }

    public int maxActive() {
        return this.maxActive;
    }

    public int maxTotal() {
        return this.maxTotal;
    }

    public int maxIdle() {
        return this.maxIdle;
    }

    public int minIdle() {
        return this.minIdle;
    }

    public long timeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public long minEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public boolean testWhileIdle() {
        return this.testWhileIdle;
    }

    public String toString() {
        return "ConnectionPoolConfiguration [exhaustedAction=" + (Object)((Object)this.exhaustedAction) + ", maxActive=" + this.maxActive + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", timeBetweenEvictionRuns=" + this.timeBetweenEvictionRuns + ", minEvictableIdleTime=" + this.minEvictableIdleTime + ", testWhileIdle=" + this.testWhileIdle + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolConfiguration that = (ConnectionPoolConfiguration)o;
        if (this.maxActive != that.maxActive) {
            return false;
        }
        if (this.maxTotal != that.maxTotal) {
            return false;
        }
        if (this.maxIdle != that.maxIdle) {
            return false;
        }
        if (this.minIdle != that.minIdle) {
            return false;
        }
        if (this.timeBetweenEvictionRuns != that.timeBetweenEvictionRuns) {
            return false;
        }
        if (this.minEvictableIdleTime != that.minEvictableIdleTime) {
            return false;
        }
        if (this.testWhileIdle != that.testWhileIdle) {
            return false;
        }
        return this.exhaustedAction == that.exhaustedAction;
    }

    public int hashCode() {
        int result = this.exhaustedAction != null ? this.exhaustedAction.hashCode() : 0;
        result = 31 * result + this.maxActive;
        result = 31 * result + this.maxTotal;
        result = 31 * result + this.maxIdle;
        result = 31 * result + this.minIdle;
        result = 31 * result + (int)(this.timeBetweenEvictionRuns ^ this.timeBetweenEvictionRuns >>> 32);
        result = 31 * result + (int)(this.minEvictableIdleTime ^ this.minEvictableIdleTime >>> 32);
        result = 31 * result + (this.testWhileIdle ? 1 : 0);
        return result;
    }
}

