/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.impl;

import infinispan.org.iq80.leveldb.Snapshot;
import infinispan.org.iq80.leveldb.impl.Version;
import java.util.concurrent.atomic.AtomicBoolean;

public class SnapshotImpl
implements Snapshot {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Version version;
    private final long lastSequence;

    SnapshotImpl(Version version, long lastSequence) {
        this.version = version;
        this.lastSequence = lastSequence;
        this.version.retain();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.version.release();
        }
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return Long.toString(this.lastSequence);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotImpl snapshot = (SnapshotImpl)o;
        if (this.lastSequence != snapshot.lastSequence) {
            return false;
        }
        return this.version.equals(snapshot.version);
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = 31 * result + (int)(this.lastSequence ^ this.lastSequence >>> 32);
        return result;
    }
}

