/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.BaseAsyncInvocationContext;
import org.infinispan.interceptors.impl.InterceptorListNode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class AsyncInterceptorChainImpl
implements AsyncInterceptorChain {
    private static final ImmutableListCopy<AsyncInterceptor> EMPTY_INTERCEPTORS_LIST = new ImmutableListCopy<AsyncInterceptor>(new AsyncInterceptor[0]);
    private static final Log log = LogFactory.getLog(AsyncInterceptorChainImpl.class);
    private final ComponentMetadataRepo componentMetadataRepo;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile List<AsyncInterceptor> interceptors = EMPTY_INTERCEPTORS_LIST;
    private volatile InterceptorListNode firstInterceptor = null;

    public AsyncInterceptorChainImpl(ComponentMetadataRepo componentMetadataRepo) {
        this.componentMetadataRepo = componentMetadataRepo;
    }

    @Start
    private void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debugf("Interceptor chain size: %d", this.size());
            log.debugf("Interceptor chain is: %s", (Object)this.toString());
        }
    }

    private void validateCustomInterceptor(Class<? extends AsyncInterceptor> i) {
        if (!(ReflectionUtil.getAllMethodsShallow(i, Inject.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Start.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Stop.class).isEmpty() || this.componentMetadataRepo.findComponentMetadata(i.getName()) != null)) {
            log.customInterceptorExpectsInjection(i.getName());
        }
    }

    private void checkInterceptor(Class<? extends AsyncInterceptor> clazz) {
        if (this.containsInterceptorType(clazz, false)) {
            throw new CacheConfigurationException("Detected interceptor of type [" + clazz.getName() + "] being added to the interceptor chain " + System.identityHashCode(this) + " more than once!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(AsyncInterceptor interceptor, int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = interceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, position, interceptor);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeInterceptor(int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.interceptors = Immutables.immutableListRemove(this.interceptors, position);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.interceptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(Class<? extends AsyncInterceptor> clazz) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), clazz)) continue;
                this.removeInterceptor(i);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean interceptorMatches(AsyncInterceptor interceptor, Class<? extends AsyncInterceptor> clazz) {
        Class<?> interceptorType = interceptor.getClass();
        return clazz == interceptorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorAfter(AsyncInterceptor toAdd, Class<? extends AsyncInterceptor> afterInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), afterInterceptor)) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, i + 1, toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public boolean addInterceptorBefore(AsyncInterceptor toAdd, Class<? extends AsyncInterceptor> beforeInterceptor, boolean isCustom) {
        if (isCustom) {
            this.validateCustomInterceptor(toAdd.getClass());
        }
        return this.addInterceptorBefore(toAdd, beforeInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorBefore(AsyncInterceptor toAdd, Class<? extends AsyncInterceptor> beforeInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), beforeInterceptor)) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, i, toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceInterceptor(AsyncInterceptor replacingInterceptor, Class<? extends AsyncInterceptor> existingInterceptorType) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = replacingInterceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), existingInterceptorType)) continue;
                this.interceptors = Immutables.immutableListReplace(this.interceptors, i, replacingInterceptor);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendInterceptor(AsyncInterceptor ci, boolean isCustom) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = ci.getClass();
            if (isCustom) {
                this.validateCustomInterceptor(interceptorClass);
            }
            this.checkInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, this.interceptors.size(), ci);
            this.rebuildInterceptors();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Object> invokeAsync(InvocationContext ctx, VisitableCommand command) {
        return ((BaseAsyncInvocationContext)ctx).invoke(command, this.firstInterceptor);
    }

    @Override
    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        try {
            return ((BaseAsyncInvocationContext)ctx).invokeSync(command, this.firstInterceptor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CacheException(throwable);
        }
    }

    @Override
    public <T extends AsyncInterceptor> T findInterceptorExtending(Class<T> interceptorClass) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            boolean isSubclass = interceptorClass.isInstance(interceptor);
            if (!isSubclass) continue;
            return (T)((AsyncInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    @Override
    public <T extends AsyncInterceptor> T findInterceptorWithClass(Class<T> interceptorClass) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            if (!this.interceptorMatches(interceptor, interceptorClass)) continue;
            return (T)((AsyncInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            sb.append("\n\t>> ");
            sb.append(interceptor);
        }
        return sb.toString();
    }

    @Override
    public boolean containsInstance(AsyncInterceptor interceptor) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor current : localInterceptors) {
            if (current != interceptor) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInterceptorType(Class<? extends AsyncInterceptor> interceptorType) {
        return this.containsInterceptorType(interceptorType, false);
    }

    @Override
    public boolean containsInterceptorType(Class<? extends AsyncInterceptor> interceptorType, boolean alsoMatchSubClasses) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            Class<?> currentInterceptorType = interceptor.getClass();
            if (!(alsoMatchSubClasses ? interceptorType.isAssignableFrom(currentInterceptorType) : interceptorType == currentInterceptorType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AsyncInterceptor> getInterceptors() {
        return this.interceptors;
    }

    private void rebuildInterceptors() {
        InterceptorListNode node = null;
        ListIterator<AsyncInterceptor> it = this.interceptors.listIterator(this.interceptors.size());
        while (it.hasPrevious()) {
            node = new InterceptorListNode(it.previous(), node);
        }
        this.firstInterceptor = node;
    }
}

