/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DeadlockDetectingInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(DeadlockDetectingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Start
    public void start() {
        if (!this.cacheConfiguration.deadlockDetection().enabled()) {
            throw new IllegalStateException("This interceptor should not be present in the chain as deadlock detection is not used!");
        }
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getKeys());
            CacheMode cacheMode = this.cacheConfiguration.clustering().cacheMode();
            if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
                if (trace) {
                    log.tracef("Locks as seen at origin are: %s", (Object)ctx.getLockedKeys());
                }
                ((DldGlobalTransaction)ctx.getGlobalTransaction()).setLocksHeldAtOrigin(ctx.getLockedKeys());
            }
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getAffectedKeys());
        }
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            if (rCtx.isOriginLocal()) {
                globalTransaction.setRemoteLockIntention(Collections.emptySet());
            }
            return null;
        });
    }
}

