/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(PartitionHandlingInterceptor.class);
    PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, DistributionManager distributionManager) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, LocalFlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return true;
        }
        Set<Flag> flags = command.getFlags();
        return flags == null || !flags.contains((Object)Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected CompletableFuture<Void> handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    @Override
    public final CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    private CompletableFuture<Void> handleDataReadCommand(InvocationContext ctx, DataCommand command) {
        Object key = command.getKey();
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof RpcException && this.performPartitionCheck(rCtx, (DataCommand)rCommand)) {
                    throw log.degradedModeKeyUnavailable(key);
                }
                throw throwable;
            }
            this.postOperationPartitionCheck(rCtx, (DataCommand)rCommand, key, rv);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable == null) {
                this.postTxCommandCheck((TxInvocationContext)rCtx);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable == null) {
                this.postTxCommandCheck((TxInvocationContext)rCtx);
            }
            return null;
        });
    }

    protected void postTxCommandCheck(TxInvocationContext ctx) {
        if (ctx.hasModifications() && this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction())) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    private Object postOperationPartitionCheck(InvocationContext ctx, DataCommand command, Object key, Object result) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkRead(key);
            if (result == null && !InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) {
                throw log.degradedModeKeyUnavailable(key);
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            GetAllCommand getAllCommand = (GetAllCommand)rCommand;
            if (throwable != null) {
                if (throwable instanceof RpcException && this.performPartitionCheck(rCtx, getAllCommand)) {
                    throw log.degradedModeKeysUnavailable(((GetAllCommand)rCommand).getKeys());
                }
                throw throwable;
            }
            if (this.performPartitionCheck(rCtx, getAllCommand)) {
                for (Object key : getAllCommand.getKeys()) {
                    this.partitionHandlingManager.checkRead(key);
                }
                Map result = (Map)rv;
                if (result.size() != getAllCommand.getKeys().size()) {
                    HashSet missingKeys = new HashSet(getAllCommand.getKeys());
                    missingKeys.removeAll(result.keySet());
                    Iterator it = missingKeys.iterator();
                    while (it.hasNext()) {
                        Object key = it.next();
                        if (!InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) continue;
                        it.remove();
                    }
                    if (!missingKeys.isEmpty()) {
                        throw log.degradedModeKeysUnavailable(missingKeys);
                    }
                }
            }
            return null;
        });
    }
}

