/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public abstract class BaseQuery
implements Query {
    private static final Log log = Logger.getMessageLogger(Log.class, BaseQuery.class.getName());
    protected final QueryFactory queryFactory;
    protected final String jpaQuery;
    protected final Map<String, Object> namedParameters;
    protected final String[] projection;
    protected final int startOffset;
    protected final int maxResults;

    protected BaseQuery(QueryFactory queryFactory, String jpaQuery, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        this.queryFactory = queryFactory;
        this.jpaQuery = jpaQuery;
        this.namedParameters = namedParameters;
        this.projection = projection != null && projection.length > 0 ? projection : null;
        this.startOffset = startOffset < 0L ? 0 : (int)startOffset;
        this.maxResults = maxResults;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public String getJPAQuery() {
        return this.jpaQuery;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.namedParameters);
    }

    @Override
    public Query setParameter(String paramName, Object paramValue) {
        if (this.namedParameters == null) {
            throw log.queryDoesNotHaveParameters();
        }
        if (paramName == null || paramName.isEmpty()) {
            throw log.parameterNameCannotBeNulOrEmpty();
        }
        if (!this.namedParameters.containsKey(paramName)) {
            throw log.parameterNotFound(paramName);
        }
        this.namedParameters.put(paramName, paramValue);
        this.resetQuery();
        return this;
    }

    @Override
    public Query setParameters(Map<String, Object> paramValues) {
        if (paramValues == null) {
            throw log.argumentCannotBeNull("paramValues");
        }
        if (this.namedParameters == null) {
            throw log.queryDoesNotHaveParameters();
        }
        HashSet<String> unknownParams = null;
        for (String paramName : paramValues.keySet()) {
            if (paramName == null || paramName.isEmpty()) {
                throw log.parameterNameCannotBeNulOrEmpty();
            }
            if (this.namedParameters.containsKey(paramName)) continue;
            if (unknownParams == null) {
                unknownParams = new HashSet<String>();
            }
            unknownParams.add(paramName);
        }
        if (unknownParams != null) {
            throw log.parametersNotFound(((Object)unknownParams).toString());
        }
        this.namedParameters.putAll(paramValues);
        this.resetQuery();
        return this;
    }

    public abstract void resetQuery();

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public String[] getProjection() {
        return this.projection;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public int getMaxResults() {
        return this.maxResults;
    }
}

