/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.util.ByteString;

public class StreamRequestCommand<K>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 47;
    private LocalStreamManager lsm;
    private Object id;
    private Type type;
    private boolean parallelStream;
    private Set<Integer> segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private Object terminalOperation;
    private int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Object getId() {
        return this.id;
    }

    private StreamRequestCommand() {
        super(null);
    }

    public StreamRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamRequestCommand(ByteString cacheName, Address origin, Object id, boolean parallelStream, Type type, Set<Integer> segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Object terminalOperation) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
        this.parallelStream = parallelStream;
        this.type = type;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.terminalOperation = terminalOperation;
    }

    @Inject
    public void inject(LocalStreamManager lsm) {
        this.lsm = lsm;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.type) {
            case TERMINAL: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (KeyTrackingTerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (KeyTrackingTerminalOperation)this.terminalOperation);
            }
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 47;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeObject(this.id);
        output.writeBoolean(this.parallelStream);
        MarshallUtil.marshallEnum(this.type, output);
        MarshallUtil.marshallCollection(this.segments, output);
        MarshallUtil.marshallCollection(this.keys, output);
        MarshallUtil.marshallCollection(this.excludedKeys, output);
        output.writeBoolean(this.includeLoader);
        output.writeObject(this.terminalOperation);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.id = input.readObject();
        this.parallelStream = input.readBoolean();
        this.type = MarshallUtil.unmarshallEnum(input, ordinal -> Type.CACHED_VALUES[ordinal]);
        this.segments = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.keys = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.excludedKeys = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.includeLoader = input.readBoolean();
        this.terminalOperation = input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public static enum Type {
        TERMINAL,
        TERMINAL_REHASH,
        TERMINAL_KEY,
        TERMINAL_KEY_REHASH;

        private static final Type[] CACHED_VALUES;

        static {
            CACHED_VALUES = Type.values();
        }
    }
}

