/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FcHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Simple flow control protocol based on a credit system")
@Deprecated
public class FC
extends Protocol {
    private static final FcHeader REPLENISH_HDR = new FcHeader(1);
    private static final FcHeader CREDIT_REQUEST_HDR = new FcHeader(2);
    @Property(description="Max number of bytes to send per receiver until an ack must be received to proceed. Default is 500000 bytes")
    private long max_credits = 500000L;
    @Property(description="Max time (in milliseconds) to block. Default is 5000 msec")
    private long max_block_time = 5000L;
    private Map<Long, Long> max_block_times = null;
    private static final ThreadLocal<Long> end_time = new ThreadLocal();
    @Property(description="The threshold (as a percentage of max_credits) at which a receiver sends more credits to a sender. Example: if max_credits is 1'000'000, and min_threshold 0.25, then we send ca. 250'000 credits to P once we've received 250'000 bytes from P")
    private double min_threshold = 0.6;
    @Property(description="Computed as max_credits x min_theshold unless explicitly set")
    private long min_credits = 0L;
    @Property(description="Does not block a down message if it is a result of handling an up message in thesame thread. Fixes JGRP-928", deprecatedMessage="not used any longer")
    private boolean ignore_synchronous_response = false;
    private int num_blockings = 0;
    private int num_credit_requests_received = 0;
    private int num_credit_requests_sent = 0;
    private int num_credit_responses_sent = 0;
    private int num_credit_responses_received = 0;
    private long total_time_blocking = 0L;
    private final BoundedList<Long> last_blockings = new BoundedList(50);
    private final ConcurrentMap<Address, Credit> sent = Util.createConcurrentMap();
    private final ConcurrentMap<Address, Credit> received = Util.createConcurrentMap();
    private final Set<Address> creditors = new HashSet<Address>(11);
    private volatile boolean running = true;
    private boolean frag_size_received = false;
    @ManagedAttribute(writable=false)
    private long lowest_credit = this.max_credits;
    private final Lock lock = new ReentrantLock();
    private final Condition credits_available = this.lock.newCondition();
    private long last_credit_request = 0L;

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
        this.total_time_blocking = 0L;
        this.last_blockings.clear();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    @ManagedAttribute(description="Number of times flow control blocks sender")
    public int getNumberOfBlockings() {
        return this.num_blockings;
    }

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    @Property(description="Max times to block for the listed messages sizes (Message.getLength()). Example: \"1000:10,5000:30,10000:500\"")
    public void setMaxBlockTimes(String str) {
        if (str == null) {
            return;
        }
        Long prev_key = null;
        Long prev_val = null;
        List<String> vals = Util.parseCommaDelimitedStrings(str);
        if (this.max_block_times == null) {
            this.max_block_times = new TreeMap<Long, Long>();
        }
        for (String tmp : vals) {
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("element '" + tmp + "'  is missing a ':' separator");
            }
            Long key = Long.parseLong(tmp.substring(0, index).trim());
            Long val = Long.parseLong(tmp.substring(index + 1).trim());
            if (key < 0L || val < 0L) {
                throw new IllegalArgumentException("keys and values must be >= 0");
            }
            if (prev_key != null && key <= prev_key) {
                throw new IllegalArgumentException("keys are not sorted: " + vals);
            }
            prev_key = key;
            if (prev_val != null && val <= prev_val) {
                throw new IllegalArgumentException("values are not sorted: " + vals);
            }
            prev_val = val;
            this.max_block_times.put(key, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("max_block_times: " + this.max_block_times);
        }
    }

    public String getMaxBlockTimes() {
        if (this.max_block_times == null) {
            return "n/a";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }

    @ManagedAttribute(description="Total time (ms) spent in flow control block")
    public long getTotalTimeBlocked() {
        return this.total_time_blocking;
    }

    @ManagedAttribute(description="Average time spent in a flow control block")
    public double getAverageTimeBlocked() {
        return this.num_blockings == 0 ? 0.0 : (double)this.total_time_blocking / (double)this.num_blockings;
    }

    @ManagedAttribute(description="Number of credit requests received")
    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    @ManagedAttribute(description="Number of credit requests sent")
    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    @ManagedAttribute(description="Number of credit responses received")
    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    @ManagedAttribute(description="Number of credit responses sent")
    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return FC.printMap(this.sent);
    }

    @ManagedOperation(description="Print receiver credits")
    public String printReceiverCredits() {
        return FC.printMap(this.received);
    }

    @ManagedOperation(description="Print credits")
    public String printCredits() {
        StringBuilder sb = new StringBuilder();
        sb.append("senders:\n").append(FC.printMap(this.sent)).append("\n\nreceivers:\n").append(FC.printMap(this.received));
        return sb.toString();
    }

    @ManagedOperation(description="Prints the creditors")
    public String printCreditors() {
        return this.creditors.toString();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("senders", FC.printMap(this.sent));
        retval.put("receivers", FC.printMap(this.received));
        return retval;
    }

    @ManagedOperation(description="Print last blocking times")
    public String showLastBlockingTimes() {
        return this.last_blockings.toString();
    }

    private long getMaxBlockTime(long length) {
        if (this.max_block_times == null) {
            return 0L;
        }
        Long retval = null;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            retval = entry.getValue();
            if (length > entry.getKey()) continue;
            break;
        }
        return retval != null ? retval : 0L;
    }

    @ManagedOperation(description="Unblock a sender")
    public void unblock() {
        this.lock.lock();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("unblocking the sender and replenishing all members, creditors are " + this.creditors);
            }
            for (Map.Entry entry : this.sent.entrySet()) {
                ((Credit)entry.getValue()).set(this.max_credits);
            }
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            this.creditors.clear();
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void init() throws Exception {
        boolean min_credits_set;
        boolean bl = min_credits_set = this.min_credits != 0L;
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        this.lowest_credit = this.max_credits;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!this.frag_size_received) {
            this.log.warn("No fragmentation protocol was found. When flow control (e.g. FC or SFC) is used, we recommend a fragmentation protocol, due to http://jira.jboss.com/jira/browse/JGRP-590");
        }
        this.lock.lock();
        try {
            this.running = true;
            this.lowest_credit = this.max_credits;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.lock.lock();
        try {
            this.running = false;
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                int length;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.Flag.NO_FC) || (length = msg.getLength()) == 0) break;
                return this.handleDownMessage(evt, msg, length);
            }
            case 56: {
                this.handleConfigEvent((Map)evt.getArg());
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.Flag.NO_FC)) break;
                FcHeader hdr = (FcHeader)msg.getHeader(this.id);
                if (hdr != null) {
                    this.handleUpEvent(hdr, msg);
                    return null;
                }
                Address sender = msg.getSrc();
                long new_credits = this.adjustCredit(this.received, sender, msg.getLength());
                try {
                    Object object = this.up_prot.up(evt);
                    return object;
                }
                finally {
                    if (new_credits > 0L) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("sending " + new_credits + " credits to " + sender);
                        }
                        this.sendCredit(sender, new_credits);
                    }
                }
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        int length = 0;
        for (Message msg : batch) {
            if (msg.isFlagSet(Message.Flag.NO_FC)) continue;
            FcHeader hdr = (FcHeader)msg.getHeader(this.id);
            if (hdr != null) {
                batch.remove(msg);
                this.handleUpEvent(hdr, msg);
                continue;
            }
            length += msg.getLength();
        }
        Address sender = batch.sender();
        long new_credits = 0L;
        if (length > 0) {
            new_credits = this.adjustCredit(this.received, sender, length);
        }
        if (!batch.isEmpty()) {
            try {
                this.up_prot.up(batch);
            }
            finally {
                if (new_credits > 0L) {
                    this.sendCredit(sender, new_credits);
                }
            }
        }
    }

    protected void handleUpEvent(FcHeader hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                ++this.num_credit_responses_received;
                this.handleCredit(msg.getSrc(), (Number)msg.getObject());
                break;
            }
            case 2: {
                ++this.num_credit_requests_received;
                Address sender = msg.getSrc();
                Long sent_credits = (Long)msg.getObject();
                if (sent_credits == null) break;
                this.handleCreditRequest(this.received, sender, sent_credits);
                break;
            }
            default: {
                this.log.error(Util.getMessage("HeaderTypeNotKnown"), "message from: " + msg.getSrc(), hdr.type);
            }
        }
    }

    private void handleConfigEvent(Map<String, Object> info) {
        Integer frag_size;
        if (info != null && (frag_size = (Integer)info.get("frag_size")) != null) {
            if ((long)frag_size.intValue() > this.max_credits) {
                this.log.warn("The fragmentation size of the fragmentation protocol is " + frag_size + ", which is greater than the max credits. While this is not incorrect, " + "it may lead to long blockings. Frag size should be less than max_credits " + "(http://jira.jboss.com/jira/browse/JGRP-590)");
            }
            this.frag_size_received = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleDownMessage(Event evt, Message msg, int length) {
        long tmp;
        Address dest = msg.getDest();
        if (this.max_block_times != null && (tmp = this.getMaxBlockTime(length)) > 0L) {
            end_time.set(System.currentTimeMillis() + tmp);
        }
        this.lock.lock();
        try {
            if ((long)length > this.lowest_credit) {
                long block_time;
                this.determineCreditors(dest, length);
                long start_blocking = System.currentTimeMillis();
                ++this.num_blockings;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Blocking (lowest_credit=" + this.lowest_credit + "; length=" + length + ")");
                }
                while ((long)length > this.lowest_credit && this.running) {
                    try {
                        Long tmp2;
                        block_time = this.max_block_time;
                        if (this.max_block_times != null && (tmp2 = end_time.get()) != null) {
                            block_time = tmp2 - start_blocking;
                        }
                        boolean rc = this.credits_available.await(block_time, TimeUnit.MILLISECONDS);
                        if ((long)length <= this.lowest_credit || rc || !this.running || !rc && this.max_block_times != null) break;
                        long wait_time = System.currentTimeMillis() - this.last_credit_request;
                        if (wait_time < this.max_block_time) continue;
                        this.last_credit_request = System.currentTimeMillis();
                        HashMap<Address, Credit> sent_copy = new HashMap<Address, Credit>(this.sent);
                        sent_copy.keySet().retainAll(this.creditors);
                        this.lock.unlock();
                        try {
                            for (Map.Entry entry : sent_copy.entrySet()) {
                                this.sendCreditRequest((Address)entry.getKey(), ((Credit)entry.getValue()).get());
                            }
                        }
                        finally {
                            this.lock.lock();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                block_time = System.currentTimeMillis() - start_blocking;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("total time blocked: " + block_time + " ms");
                }
                this.total_time_blocking += block_time;
                this.last_blockings.add(block_time);
            }
            if ((tmp = this.decrementCredit(this.sent, dest, length)) != -1L) {
                this.lowest_credit = Math.min(tmp, this.lowest_credit);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.down_prot.down(evt);
    }

    private void determineCreditors(Address dest, int length) {
        if (dest == null) {
            for (Map.Entry entry : this.sent.entrySet()) {
                if (((Credit)entry.getValue()).get() > (long)length) continue;
                this.creditors.add((Address)entry.getKey());
            }
        } else {
            Credit cred = (Credit)this.sent.get(dest);
            if (cred != null && cred.get() <= (long)length) {
                this.creditors.add(dest);
            }
        }
    }

    private long decrementCredit(Map<Address, Credit> map, Address dest, long credits) {
        long lowest = this.max_credits;
        if (dest == null) {
            if (map.isEmpty()) {
                return -1L;
            }
            for (Credit cred : map.values()) {
                lowest = Math.min(cred.decrement(credits), lowest);
            }
            return lowest;
        }
        Credit cred = map.get(dest);
        if (cred != null) {
            lowest = cred.decrement(credits);
            return lowest;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCredit(Address sender, Number increase) {
        if (sender == null) {
            return;
        }
        StringBuilder sb = null;
        this.lock.lock();
        try {
            Credit cred = (Credit)this.sent.get(sender);
            if (cred == null) {
                return;
            }
            long new_credit = Math.min(this.max_credits, cred.get() + increase.longValue());
            if (this.log.isTraceEnabled()) {
                sb = new StringBuilder();
                sb.append("received credit from ").append(sender).append(", old credit was ").append(cred).append(", new credits are ").append(new_credit).append(".\nCreditors before are: ").append(this.creditors);
            }
            cred.increment(increase.longValue());
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            if (!this.creditors.isEmpty() && this.creditors.remove(sender) && this.creditors.isEmpty()) {
                this.credits_available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static long computeLowestCredit(Map<Address, Credit> m) {
        Collection<Credit> credits = m.values();
        return Collections.min(credits).get();
    }

    private long adjustCredit(Map<Address, Credit> map, Address sender, int length) {
        if (sender == null || length == 0) {
            return 0L;
        }
        Credit cred = map.get(sender);
        if (cred == null) {
            return 0L;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sender " + sender + " minus " + length + " credits, " + (cred.get() - (long)length) + " remaining");
        }
        return cred.decrementAndGet(length);
    }

    private void handleCreditRequest(Map<Address, Credit> map, Address sender, long left_credits) {
        if (sender == null) {
            return;
        }
        Credit cred = map.get(sender);
        if (cred == null) {
            return;
        }
        long credit_response = Math.min(this.max_credits - left_credits, this.max_credits);
        if (this.log.isTraceEnabled()) {
            this.log.trace("received credit request from " + sender + ": sending " + credit_response + " credits");
        }
        cred.set(this.max_credits);
        this.sendCredit(sender, credit_response);
    }

    private void sendCredit(Address dest, long credit) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("replenishing " + dest + " with " + credit + " credits");
        }
        Number number = credit < Integer.MAX_VALUE ? (Number)((int)credit) : (Number)credit;
        Message msg = new Message(dest, number).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE).putHeader(this.id, REPLENISH_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    private void sendCreditRequest(Address dest, Long credits_left) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending credit request to " + dest);
        }
        Message msg = new Message(dest, credits_left).setFlag(Message.Flag.DONT_BUNDLE, Message.Flag.INTERNAL).putHeader(this.id, CREDIT_REQUEST_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_requests_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(List<Address> mbrs) {
        if (mbrs == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("new membership: " + mbrs);
        }
        this.lock.lock();
        try {
            Address addr2;
            for (Address addr2 : mbrs) {
                if (!this.received.containsKey(addr2)) {
                    this.received.put(addr2, new Credit(this.max_credits));
                }
                if (this.sent.containsKey(addr2)) continue;
                this.sent.put(addr2, new Credit(this.max_credits));
            }
            Iterator<Object> it = this.received.keySet().iterator();
            while (it.hasNext()) {
                addr2 = (Address)it.next();
                if (mbrs.contains(addr2)) continue;
                it.remove();
            }
            it = this.sent.keySet().iterator();
            while (it.hasNext()) {
                addr2 = (Address)it.next();
                if (mbrs.contains(addr2)) continue;
                it.remove();
            }
            it = this.creditors.iterator();
            while (it.hasNext()) {
                Address creditor = (Address)it.next();
                if (mbrs.contains(creditor)) continue;
                it.remove();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("creditors are " + this.creditors);
            }
            if (this.creditors.isEmpty()) {
                this.lowest_credit = FC.computeLowestCredit(this.sent);
                this.credits_available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String printMap(Map<Address, Credit> m) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Credit> entry : m.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private class Credit
    implements Comparable {
        private long credits_left;

        private Credit(long credits) {
            this.credits_left = credits;
        }

        private synchronized long decrementAndGet(long credits) {
            this.credits_left = Math.max(0L, this.credits_left - credits);
            long credit_response = FC.this.max_credits - this.credits_left;
            if (credit_response >= FC.this.min_credits) {
                this.credits_left = FC.this.max_credits;
                return credit_response;
            }
            return 0L;
        }

        private synchronized long decrement(long credits) {
            this.credits_left = Math.max(0L, this.credits_left - credits);
            return this.credits_left;
        }

        private synchronized long get() {
            return this.credits_left;
        }

        private synchronized void set(long new_credits) {
            this.credits_left = Math.min(FC.this.max_credits, new_credits);
        }

        private synchronized long increment(long credits) {
            this.credits_left = Math.min(FC.this.max_credits, this.credits_left + credits);
            return this.credits_left;
        }

        public String toString() {
            return String.valueOf(this.credits_left);
        }

        public int compareTo(Object o) {
            Credit other = (Credit)o;
            return this.credits_left < other.credits_left ? -1 : (this.credits_left > other.credits_left ? 1 : 0);
        }
    }
}

