/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.hash;

import java.io.ObjectInput;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.exts.NoStateExternalizer;

@ThreadSafe
@Immutable
public class MurmurHash3
implements Hash {
    private static final MurmurHash3 instance = new MurmurHash3();
    public static final byte INVALID_CHAR = 63;

    public static MurmurHash3 getInstance() {
        return instance;
    }

    private MurmurHash3() {
    }

    static long getblock(byte[] key, int i) {
        return (long)key[i + 0] & 0xFFL | ((long)key[i + 1] & 0xFFL) << 8 | ((long)key[i + 2] & 0xFFL) << 16 | ((long)key[i + 3] & 0xFFL) << 24 | ((long)key[i + 4] & 0xFFL) << 32 | ((long)key[i + 5] & 0xFFL) << 40 | ((long)key[i + 6] & 0xFFL) << 48 | ((long)key[i + 7] & 0xFFL) << 56;
    }

    static void bmix(State state) {
        state.k1 *= state.c1;
        state.k1 = state.k1 << 23 | state.k1 >>> 41;
        state.k1 *= state.c2;
        state.h1 ^= state.k1;
        state.h1 += state.h2;
        state.h2 = state.h2 << 41 | state.h2 >>> 23;
        state.k2 *= state.c2;
        state.k2 = state.k2 << 23 | state.k2 >>> 41;
        state.k2 *= state.c1;
        state.h2 ^= state.k2;
        state.h2 += state.h1;
        state.h1 = state.h1 * 3L + 1390208809L;
        state.h2 = state.h2 * 3L + 944331445L;
        state.c1 = state.c1 * 5L + 2071795100L;
        state.c2 = state.c2 * 5L + 1808688022L;
    }

    static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long[] MurmurHash3_x64_128(byte[] key, int seed) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < key.length / 16; ++i) {
            state.k1 = MurmurHash3.getblock(key, i * 2 * 8);
            state.k2 = MurmurHash3.getblock(key, (i * 2 + 1) * 8);
            MurmurHash3.bmix(state);
        }
        state.k1 = 0L;
        state.k2 = 0L;
        int tail = key.length >>> 4 << 4;
        switch (key.length & 0xF) {
            case 15: {
                state.k2 ^= (long)key[tail + 14] << 48;
            }
            case 14: {
                state.k2 ^= (long)key[tail + 13] << 40;
            }
            case 13: {
                state.k2 ^= (long)key[tail + 12] << 32;
            }
            case 12: {
                state.k2 ^= (long)key[tail + 11] << 24;
            }
            case 11: {
                state.k2 ^= (long)key[tail + 10] << 16;
            }
            case 10: {
                state.k2 ^= (long)key[tail + 9] << 8;
            }
            case 9: {
                state.k2 ^= (long)key[tail + 8];
            }
            case 8: {
                state.k1 ^= (long)key[tail + 7] << 56;
            }
            case 7: {
                state.k1 ^= (long)key[tail + 6] << 48;
            }
            case 6: {
                state.k1 ^= (long)key[tail + 5] << 40;
            }
            case 5: {
                state.k1 ^= (long)key[tail + 4] << 32;
            }
            case 4: {
                state.k1 ^= (long)key[tail + 3] << 24;
            }
            case 3: {
                state.k1 ^= (long)key[tail + 2] << 16;
            }
            case 2: {
                state.k1 ^= (long)key[tail + 1] << 8;
            }
            case 1: {
                state.k1 ^= (long)key[tail + 0];
                MurmurHash3.bmix(state);
            }
        }
        state.h2 ^= (long)key.length;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return new long[]{state.h1, state.h2};
    }

    public static long MurmurHash3_x64_64(byte[] key, int seed) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < key.length / 16; ++i) {
            state.k1 = MurmurHash3.getblock(key, i * 2 * 8);
            state.k2 = MurmurHash3.getblock(key, (i * 2 + 1) * 8);
            MurmurHash3.bmix(state);
        }
        state.k1 = 0L;
        state.k2 = 0L;
        int tail = key.length >>> 4 << 4;
        switch (key.length & 0xF) {
            case 15: {
                state.k2 ^= (long)key[tail + 14] << 48;
            }
            case 14: {
                state.k2 ^= (long)key[tail + 13] << 40;
            }
            case 13: {
                state.k2 ^= (long)key[tail + 12] << 32;
            }
            case 12: {
                state.k2 ^= (long)key[tail + 11] << 24;
            }
            case 11: {
                state.k2 ^= (long)key[tail + 10] << 16;
            }
            case 10: {
                state.k2 ^= (long)key[tail + 9] << 8;
            }
            case 9: {
                state.k2 ^= (long)key[tail + 8];
            }
            case 8: {
                state.k1 ^= (long)key[tail + 7] << 56;
            }
            case 7: {
                state.k1 ^= (long)key[tail + 6] << 48;
            }
            case 6: {
                state.k1 ^= (long)key[tail + 5] << 40;
            }
            case 5: {
                state.k1 ^= (long)key[tail + 4] << 32;
            }
            case 4: {
                state.k1 ^= (long)key[tail + 3] << 24;
            }
            case 3: {
                state.k1 ^= (long)key[tail + 2] << 16;
            }
            case 2: {
                state.k1 ^= (long)key[tail + 1] << 8;
            }
            case 1: {
                state.k1 ^= (long)key[tail + 0];
                MurmurHash3.bmix(state);
            }
        }
        state.h2 ^= (long)key.length;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return state.h1;
    }

    public static int MurmurHash3_x64_32(byte[] key, int seed) {
        return (int)(MurmurHash3.MurmurHash3_x64_64(key, seed) >>> 32);
    }

    public static long[] MurmurHash3_x64_128(long[] key, int seed) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < key.length / 2; ++i) {
            state.k1 = key[i * 2];
            state.k2 = key[i * 2 + 1];
            MurmurHash3.bmix(state);
        }
        long tail = key[key.length - 1];
        if ((key.length & 1) == 1) {
            state.k1 ^= tail;
            MurmurHash3.bmix(state);
        }
        state.h2 ^= (long)(key.length * 8);
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return new long[]{state.h1, state.h2};
    }

    public static long MurmurHash3_x64_64(long[] key, int seed) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < key.length / 2; ++i) {
            state.k1 = key[i * 2];
            state.k2 = key[i * 2 + 1];
            MurmurHash3.bmix(state);
        }
        long tail = key[key.length - 1];
        if (key.length % 2 != 0) {
            state.k1 ^= tail;
            MurmurHash3.bmix(state);
        }
        state.h2 ^= (long)(key.length * 8);
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return state.h1;
    }

    public static int MurmurHash3_x64_32(long[] key, int seed) {
        return (int)(MurmurHash3.MurmurHash3_x64_64(key, seed) >>> 32);
    }

    @Override
    public int hash(byte[] payload) {
        return MurmurHash3.MurmurHash3_x64_32(payload, 9001);
    }

    public static int hash(long[] payload) {
        return MurmurHash3.MurmurHash3_x64_32(payload, 9001);
    }

    @Override
    public int hash(int hashcode) {
        byte b0 = (byte)hashcode;
        byte b1 = (byte)(hashcode >>> 8);
        byte b2 = (byte)(hashcode >>> 16);
        byte b3 = (byte)(hashcode >>> 24);
        State state = new State();
        state.h1 = -7824752305899908771L;
        state.h2 = 6371974587529097428L;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        state.k1 = 0L;
        state.k2 = 0L;
        state.k1 ^= (long)b3 << 24;
        state.k1 ^= (long)b2 << 16;
        state.k1 ^= (long)b1 << 8;
        state.k1 ^= (long)b0;
        MurmurHash3.bmix(state);
        state.h2 ^= 4L;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return (int)(state.h1 >>> 32);
    }

    @Override
    public int hash(Object o) {
        if (o instanceof byte[]) {
            return this.hash((byte[])o);
        }
        if (o instanceof long[]) {
            return MurmurHash3.hash((long[])o);
        }
        if (o instanceof String) {
            return this.hashString((String)o);
        }
        return this.hash(o.hashCode());
    }

    private int hashString(String s) {
        return (int)(this.MurmurHash3_x64_64_String(s, 9001L) >> 32);
    }

    private long MurmurHash3_x64_64_String(String s, long seed) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ seed;
        state.h2 = 0x586DCD208F7CD3FDL ^ seed;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        int byteLen = 0;
        int stringLen = s.length();
        for (int i = 0; i < stringLen; ++i) {
            byte b3;
            byte b2;
            byte b1;
            int cp;
            int c1 = s.charAt(i);
            if (!Character.isSurrogate((char)c1)) {
                cp = c1;
            } else if (Character.isHighSurrogate((char)c1)) {
                if (i + 1 < stringLen) {
                    char c2 = s.charAt(i + 1);
                    if (Character.isLowSurrogate(c2)) {
                        ++i;
                        cp = Character.toCodePoint((char)c1, c2);
                    } else {
                        cp = 63;
                    }
                } else {
                    cp = 63;
                }
            } else {
                cp = 63;
            }
            if (cp <= 127) {
                this.addByte(state, (byte)cp, byteLen++);
                continue;
            }
            if (cp <= 2047) {
                b1 = (byte)(0xC0 | 0x1F & cp >> 6);
                b2 = (byte)(0x80 | 0x3F & cp);
                this.addByte(state, b1, byteLen++);
                this.addByte(state, b2, byteLen++);
                continue;
            }
            if (cp <= 65535) {
                b1 = (byte)(0xE0 | 0xF & cp >> 12);
                b2 = (byte)(0x80 | 0x3F & cp >> 6);
                b3 = (byte)(0x80 | 0x3F & cp);
                this.addByte(state, b1, byteLen++);
                this.addByte(state, b2, byteLen++);
                this.addByte(state, b3, byteLen++);
                continue;
            }
            b1 = (byte)(0xF0 | 7 & cp >> 18);
            b2 = (byte)(0x80 | 0x3F & cp >> 12);
            b3 = (byte)(0x80 | 0x3F & cp >> 6);
            byte b4 = (byte)(0x80 | 0x3F & cp);
            this.addByte(state, b1, byteLen++);
            this.addByte(state, b2, byteLen++);
            this.addByte(state, b3, byteLen++);
            this.addByte(state, b4, byteLen++);
        }
        long savedK1 = state.k1;
        long savedK2 = state.k2;
        state.k1 = 0L;
        state.k2 = 0L;
        switch (byteLen & 0xF) {
            case 15: {
                state.k2 ^= (long)((byte)(savedK2 >> 48)) << 48;
            }
            case 14: {
                state.k2 ^= (long)((byte)(savedK2 >> 40)) << 40;
            }
            case 13: {
                state.k2 ^= (long)((byte)(savedK2 >> 32)) << 32;
            }
            case 12: {
                state.k2 ^= (long)((byte)(savedK2 >> 24)) << 24;
            }
            case 11: {
                state.k2 ^= (long)((byte)(savedK2 >> 16)) << 16;
            }
            case 10: {
                state.k2 ^= (long)((byte)(savedK2 >> 8)) << 8;
            }
            case 9: {
                state.k2 ^= (long)((byte)savedK2);
            }
            case 8: {
                state.k1 ^= (long)((byte)(savedK1 >> 56)) << 56;
            }
            case 7: {
                state.k1 ^= (long)((byte)(savedK1 >> 48)) << 48;
            }
            case 6: {
                state.k1 ^= (long)((byte)(savedK1 >> 40)) << 40;
            }
            case 5: {
                state.k1 ^= (long)((byte)(savedK1 >> 32)) << 32;
            }
            case 4: {
                state.k1 ^= (long)((byte)(savedK1 >> 24)) << 24;
            }
            case 3: {
                state.k1 ^= (long)((byte)(savedK1 >> 16)) << 16;
            }
            case 2: {
                state.k1 ^= (long)((byte)(savedK1 >> 8)) << 8;
            }
            case 1: {
                state.k1 ^= (long)((byte)savedK1);
                MurmurHash3.bmix(state);
            }
        }
        state.h2 ^= (long)byteLen;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return state.h1;
    }

    private void addByte(State state, byte b, int len) {
        int shift = (len & 7) * 8;
        long bb = ((long)b & 0xFFL) << shift;
        if ((len & 8) == 0) {
            state.k1 |= bb;
        } else {
            state.k2 |= bb;
            if ((len & 0xF) == 15) {
                MurmurHash3.bmix(state);
                state.k1 = 0L;
                state.k2 = 0L;
            }
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "MurmurHash3";
    }

    public static class Externalizer
    extends NoStateExternalizer<MurmurHash3> {
        @Override
        public Set<Class<? extends MurmurHash3>> getTypeClasses() {
            return Collections.singleton(MurmurHash3.class);
        }

        @Override
        public MurmurHash3 readObject(ObjectInput input) {
            return instance;
        }

        @Override
        public Integer getId() {
            return 73;
        }
    }

    static class State {
        long h1;
        long h2;
        long k1;
        long k2;
        long c1;
        long c2;

        State() {
        }
    }
}

