/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;

public class AsyncSubCommandInvoker
implements AsyncInterceptor.ForkReturnHandler {
    private Object returnValue;
    private final Iterator<VisitableCommand> subCommands;
    private final AsyncInterceptor.ForkReturnHandler finalReturnHandler;

    private AsyncSubCommandInvoker(Object returnValue, Iterator<VisitableCommand> subCommands, AsyncInterceptor.ForkReturnHandler finalReturnHandler) {
        this.returnValue = returnValue;
        this.subCommands = subCommands;
        this.finalReturnHandler = finalReturnHandler;
    }

    public static CompletableFuture<Void> forEach(InvocationContext ctx, VisitableCommand command, Object returnValue, Stream<VisitableCommand> subCommandStream, AsyncInterceptor.ForkReturnHandler finalReturnHandler) throws Throwable {
        AsyncSubCommandInvoker forker = new AsyncSubCommandInvoker(returnValue, subCommandStream.iterator(), finalReturnHandler);
        return forker.handle(ctx, command, null, null);
    }

    @Override
    public CompletableFuture<Void> handle(InvocationContext rCtx, VisitableCommand rCommand, Object subReturnValue, Throwable throwable) throws Throwable {
        if (throwable != null) {
            throw throwable;
        }
        if (this.subCommands.hasNext()) {
            VisitableCommand newCommand = this.subCommands.next();
            return rCtx.forkInvocation(newCommand, this);
        }
        return this.finalReturnHandler.handle(rCtx, rCommand, this.returnValue, null);
    }
}

