/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BatchingInterceptor
extends DDAsyncInterceptor {
    private BatchContainer batchContainer;
    private TransactionManager transactionManager;
    private InvocationContextFactory invocationContextFactory;
    private AsyncInterceptorChain invoker;
    private static final Log log = LogFactory.getLog(BatchingInterceptor.class);

    @Inject
    private void inject(BatchContainer batchContainer, TransactionManager transactionManager, InvocationContextFactory invocationContextFactory, AsyncInterceptorChain invoker) {
        this.batchContainer = batchContainer;
        this.transactionManager = transactionManager;
        this.invocationContextFactory = invocationContextFactory;
        this.invoker = invoker;
    }

    @Override
    public CompletableFuture<Void> visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx;
        if (!ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        if (this.transactionManager.getTransaction() != null || (tx = this.batchContainer.getBatchTransaction()) == null) {
            return ctx.continueInvocation();
        }
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (this.transactionManager.getTransaction() != null && this.batchContainer.isSuspendTxAfterInvocation()) {
                this.transactionManager.suspend();
            }
            return null;
        });
        this.transactionManager.resume(tx);
        if (ctx.isInTxScope()) {
            return ctx.continueInvocation();
        }
        log.tracef("Called with a non-tx invocation context: %s", (Object)ctx);
        InvocationContext txInvocationContext = this.invocationContextFactory.createInvocationContext(true, -1);
        return this.invoker.invokeAsync(txInvocationContext, command).thenCompose(ctx::shortCircuit);
    }
}

