/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);
    private CommandsFactory cf;
    private StateTransferManager stateTransferManager;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory factory, StateTransferManager stateTransferManager) {
        this.cf = factory;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    protected final CompletableFuture<Void> visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
                throw throwable;
            }
            if (!rCtx.isInTxScope()) {
                this.lockManager.unlockAll(rCtx);
            }
            return null;
        });
        if (!this.readNeedsLock(ctx, command)) {
            return ctx.continueInvocation();
        }
        Object key = command.getKey();
        if (!this.needRemoteLocks(ctx, key, (LocalFlagAffectedCommand)command)) {
            return this.acquireLocalLock(ctx, command, key);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        return ctx.forkInvocation(lcc, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            return this.acquireLocalLock(rCtx, (DataCommand)rCommand, key);
        });
    }

    private boolean readNeedsLock(InvocationContext ctx, LocalFlagAffectedCommand command) {
        return ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command);
    }

    private CompletableFuture<Void> acquireLocalLock(InvocationContext ctx, LocalFlagAffectedCommand command, Object key) throws InterruptedException {
        log.tracef("acquireLocalLock", new Object[0]);
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        this.lockOrRegisterBackupLock(txContext, key, this.getLockTimeoutMillis(command));
        txContext.addAffectedKey(key);
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
                throw throwable;
            }
            return null;
        });
        if (!this.readNeedsLock(ctx, command)) {
            return ctx.continueInvocation();
        }
        Collection<?> keys = command.getKeys();
        if (!this.needRemoteLocks(ctx, keys, (LocalFlagAffectedCommand)command)) {
            return this.acquireLocalLocks(ctx, command, keys);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        return ctx.forkInvocation(lcc, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            return this.acquireLocalLocks(rCtx, (LocalFlagAffectedCommand)((Object)rCommand), keys);
        });
    }

    private CompletableFuture<Void> acquireLocalLocks(InvocationContext ctx, LocalFlagAffectedCommand command, Collection<?> keys) throws InterruptedException {
        this.lockAllOrRegisterBackupLock((TxInvocationContext)ctx, keys, this.getLockTimeoutMillis(command));
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return ctx.continueInvocation();
        }
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
            }
            return null;
        });
        if (this.hasSkipLocking(command)) {
            return ctx.continueInvocation();
        }
        Set<Object> affectedKeys = command.getMap().keySet();
        if (!this.needRemoteLocks(ctx, affectedKeys, (LocalFlagAffectedCommand)command)) {
            return this.acquireLocalLocks(ctx, command, affectedKeys);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(affectedKeys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        return ctx.forkInvocation(lcc, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            return this.acquireLocalLocks(rCtx, (LocalFlagAffectedCommand)((Object)rCommand), affectedKeys);
        });
    }

    @Override
    protected CompletableFuture<Void> visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
            return null;
        });
        Object key = command.getKey();
        if (this.hasSkipLocking(command)) {
            ((TxInvocationContext)ctx).addAffectedKey(key);
            return ctx.continueInvocation();
        }
        if (!this.needRemoteLocks(ctx, key, (LocalFlagAffectedCommand)command)) {
            return this.acquireLocalLock(ctx, command, key);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        return ctx.forkInvocation(lcc, (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            return this.acquireLocalLock(rCtx, (DataCommand)rCommand, key);
        });
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
            return null;
        });
        if (this.hasSkipLocking(command)) {
            return ctx.continueInvocation();
        }
        Object[] compositeKeys = command.getCompositeKeys();
        HashSet<Object> keysToLock = new HashSet<Object>(Arrays.asList(compositeKeys));
        if (this.needRemoteLocks(ctx, keysToLock, (LocalFlagAffectedCommand)command)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(keysToLock, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            return ctx.forkInvocation(lcc, (rCtx, rCommand, rv, throwable) -> {
                if (throwable != null) {
                    throw throwable;
                }
                ((TxInvocationContext)rCtx).addAllAffectedKeys(keysToLock);
                this.acquireLocalCompositeLocks((ApplyDeltaCommand)rCommand, keysToLock, rCtx);
                return rCtx.continueInvocation();
            });
        }
        this.acquireLocalCompositeLocks(command, keysToLock, ctx);
        return ctx.continueInvocation();
    }

    private void acquireLocalCompositeLocks(ApplyDeltaCommand command, Set<Object> keysToLock, InvocationContext ctx1) throws InterruptedException {
        if (this.cdl.localNodeIsPrimaryOwner(command.getKey())) {
            this.lockAllAndRecord(ctx1, keysToLock, this.getLockTimeoutMillis(command));
        } else if (this.cdl.localNodeIsOwner(command.getKey())) {
            TxInvocationContext txContext = (TxInvocationContext)ctx1;
            for (Object key : keysToLock) {
                ((AbstractCacheTransaction)txContext.getCacheTransaction()).addBackupLockForKey(key);
            }
        }
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        boolean skipLocking = this.hasSkipLocking(command);
        if (skipLocking) {
            return ctx.shortCircuit(false);
        }
        if (ctx.isOriginLocal()) {
            boolean needBackupLocks;
            boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.localNodeIsPrimaryOwner(command.getSingleKey());
            boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
            if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                if (localTx.getAffectedKeys().containsAll(command.getKeys())) {
                    if (this.trace) {
                        log.tracef("Already own locks on keys: %s, skipping remote call", (Object)command.getKeys());
                    }
                    return ctx.shortCircuit(true);
                }
            } else {
                if (this.trace) {
                    log.tracef("Single key %s and local, skipping remote call", command.getSingleKey());
                }
                return ctx.shortCircuit(this.localLockCommandWork(ctx, command));
            }
        }
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            this.rethrowAndReleaseLocksIfNeeded(rCtx, throwable);
            return CompletableFuture.completedFuture(this.localLockCommandWork(rCtx, (LockControlCommand)rCommand));
        });
    }

    private boolean localLockCommandWork(InvocationContext ctx, LockControlCommand command) throws InterruptedException {
        TxInvocationContext txInvocationContext = (TxInvocationContext)ctx;
        if (ctx.isOriginLocal()) {
            txInvocationContext.addAllAffectedKeys(command.getKeys());
        }
        if (command.isUnlock()) {
            if (ctx.isOriginLocal()) {
                throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
            }
            this.releaseLocksOnFailureBeforePrepare(ctx);
            return false;
        }
        ctx.onReturn((ctx2, command2, rv1, throwable1) -> {
            this.rethrowAndReleaseLocksIfNeeded(ctx, throwable1);
            return null;
        });
        this.lockAllOrRegisterBackupLock(txInvocationContext, command.getKeys(), this.getLockTimeoutMillis(command));
        return true;
    }

    private void rethrowAndReleaseLocksIfNeeded(InvocationContext ctx, Throwable throwable) throws Throwable {
        if (throwable != null) {
            if (!(throwable instanceof OutdatedTopologyException)) {
                this.releaseLocksOnFailureBeforePrepare(ctx);
            }
            throw throwable;
        }
    }

    private boolean needRemoteLocks(InvocationContext ctx, Collection<?> keys, LocalFlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(keys) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().containsAll(keys);
            if (!needRemoteLock) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", (Object)keys);
            }
        }
        return needRemoteLock;
    }

    private boolean needRemoteLocks(InvocationContext ctx, Object key, LocalFlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(key) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().contains(key);
            if (!needRemoteLock) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
            }
        }
        return needRemoteLock;
    }

    private boolean isLockOwner(Collection<?> keys) {
        for (Object key : keys) {
            if (LockUtil.getLockOwnership(key, this.cdl) == LockUtil.LockOwnership.PRIMARY) continue;
            return false;
        }
        return true;
    }

    private boolean isLockOwner(Object key) {
        return LockUtil.getLockOwnership(key, this.cdl) == LockUtil.LockOwnership.PRIMARY;
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }

    private void releaseLocksOnFailureBeforePrepare(InvocationContext ctx) {
        this.lockManager.unlockAll(ctx);
        if (ctx.isOriginLocal() && ctx.isInTxScope() && this.rpcManager != null) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            TxCompletionNotificationCommand command = this.cf.buildTxCompletionNotificationCommand(null, txContext.getGlobalTransaction());
            LocalTransaction cacheTransaction = (LocalTransaction)txContext.getCacheTransaction();
            this.rpcManager.invokeRemotely(cacheTransaction.getRemoteLocksAcquired(), command, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
        }
    }
}

