/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common.server;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.ping.common.OpenshiftPing;
import org.jgroups.ping.common.server.Server;

public abstract class AbstractServer
implements Server {
    protected final int port;
    protected final Map<String, Channel> CHANNELS = new HashMap<String, Channel>();

    protected AbstractServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Channel getChannel(String clusterName) {
        if (clusterName != null) {
            Map<String, Channel> map = this.CHANNELS;
            synchronized (map) {
                return this.CHANNELS.get(clusterName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChannel(Channel channel) {
        String clusterName = this.getClusterName(channel);
        if (clusterName != null) {
            Map<String, Channel> map = this.CHANNELS;
            synchronized (map) {
                this.CHANNELS.put(clusterName, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeChannel(Channel channel) {
        String clusterName = this.getClusterName(channel);
        if (clusterName != null) {
            Map<String, Channel> map = this.CHANNELS;
            synchronized (map) {
                this.CHANNELS.remove(clusterName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasChannels() {
        Map<String, Channel> map = this.CHANNELS;
        synchronized (map) {
            return !this.CHANNELS.isEmpty();
        }
    }

    private String getClusterName(Channel channel) {
        String clusterName;
        if (channel != null && (clusterName = channel.getClusterName()) == null && channel instanceof JChannel) {
            try {
                Field field = JChannel.class.getDeclaredField("cluster_name");
                field.setAccessible(true);
                return (String)field.get(channel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected final void handlePingRequest(Channel channel, InputStream stream) throws Exception {
        if (channel != null) {
            OpenshiftPing handler = (OpenshiftPing)channel.getProtocolStack().findProtocol((Class<?>)OpenshiftPing.class);
            handler.handlePingRequest(stream);
        }
    }
}

