/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.kube;

import infinispan.org.jboss.dmr.ModelNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.ping.common.Utils;
import org.jgroups.ping.common.stream.StreamProvider;
import org.jgroups.ping.kube.Container;
import org.jgroups.ping.kube.Pod;
import org.jgroups.ping.kube.Port;

public class Client {
    private static final Logger log = Logger.getLogger(Client.class.getName());
    private final String masterUrl;
    private final Map<String, String> headers;
    private final int connectTimeout;
    private final int readTimeout;
    private final int operationAttempts;
    private final long operationSleep;
    private final StreamProvider streamProvider;
    private final int serverPort;
    private final String info;

    public Client(String masterUrl, Map<String, String> headers, int connectTimeout, int readTimeout, int operationAttempts, long operationSleep, StreamProvider streamProvider, int serverPort) {
        this.masterUrl = masterUrl;
        this.headers = headers;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.operationAttempts = operationAttempts;
        this.operationSleep = operationSleep;
        this.streamProvider = streamProvider;
        this.serverPort = serverPort;
        TreeMap<String, String> maskedHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if ("Authorization".equalsIgnoreCase(key) && value != null) {
                    value = "#MASKED:" + value.length() + "#";
                }
                maskedHeaders.put(key, value);
            }
        }
        this.info = String.format("%s[masterUrl=%s, headers=%s, connectTimeout=%s, readTimeout=%s, operationAttempts=%s, operationSleep=%s, streamProvider=%s]", this.getClass().getSimpleName(), masterUrl, maskedHeaders, connectTimeout, readTimeout, operationAttempts, operationSleep, streamProvider);
    }

    public final String info() {
        return this.info;
    }

    protected ModelNode getNode(String op, String namespace, String labels) throws Exception {
        String url = this.masterUrl;
        if (namespace != null && namespace.length() > 0) {
            url = url + "/namespaces/" + Utils.urlencode(namespace);
        }
        url = url + "/" + op;
        if (labels != null && labels.length() > 0) {
            url = url + "?labelSelector=" + Utils.urlencode(labels);
        }
        try (InputStream stream = Utils.openStream(url, this.headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, this.streamProvider);){
            ModelNode modelNode = ModelNode.fromJSONStream(stream);
            return modelNode;
        }
    }

    public final List<Pod> getPods(String namespace, String labels) throws Exception {
        ModelNode root = this.getNode("pods", namespace, labels);
        ArrayList<Pod> pods = new ArrayList<Pod>();
        List<ModelNode> itemNodes = root.get("items").asList();
        for (ModelNode itemNode : itemNodes) {
            ModelNode podIPNode;
            ModelNode specNode = itemNode.get("spec");
            ModelNode statusNode = itemNode.get("status");
            ModelNode phaseNode = statusNode.get("phase");
            if (!phaseNode.isDefined() || !"Running".equals(phaseNode.asString()) || !(podIPNode = statusNode.get("podIP")).isDefined()) continue;
            String podIP = podIPNode.asString();
            Pod pod = new Pod(podIP);
            ModelNode containersNode = specNode.get("containers");
            if (!containersNode.isDefined()) continue;
            List<ModelNode> containerNodes = containersNode.asList();
            for (ModelNode containerNode : containerNodes) {
                ModelNode portsNode = containerNode.get("ports");
                if (!portsNode.isDefined()) continue;
                Container container = new Container();
                List<ModelNode> portNodes = portsNode.asList();
                for (ModelNode portNode : portNodes) {
                    ModelNode containerPortNode;
                    Optional<String> portName = Optional.empty();
                    ModelNode portNameNode = portNode.get("name");
                    if (portNameNode.isDefined()) {
                        portName = Optional.of(portNameNode.asString());
                    }
                    if (!(containerPortNode = portNode.get("containerPort")).isDefined()) continue;
                    int containerPort = containerPortNode.asInt();
                    Port port = new Port(portName, containerPort);
                    container.addPort(port);
                }
                pod.addContainer(container);
            }
            pods.add(pod);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("getPods(%s, %s) = %s", namespace, labels, pods));
        }
        return pods;
    }

    public boolean accept(Container container) {
        return container.getPorts().stream().filter(port -> this.accept((Port)port)).findAny().isPresent();
    }

    public boolean accept(Port port) {
        return this.serverPort == port.getContainerPort();
    }
}

