/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.CloseableSpliteratorMapper;
import org.infinispan.commons.util.InjectiveFunction;
import org.infinispan.compat.ConverterEntryMapper;
import org.infinispan.compat.ConverterKeyMapper;
import org.infinispan.compat.ConverterValueMapper;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;
import org.infinispan.metadata.Metadata;

public class TypeConverterDelegatingAdvancedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final TypeConverter converter;
    private InternalEntryFactory entryFactory;
    final ConverterEntryMapper entryMapper = new ConverterEntryMapper();
    final ConverterKeyMapper keyMapper = new ConverterKeyMapper();
    final ConverterValueMapper valueMapper = new ConverterValueMapper();

    public TypeConverterDelegatingAdvancedCache(AdvancedCache<K, V> cache, TypeConverter converter) {
        super(cache, (AdvancedCache<K, V> c) -> new TypeConverterDelegatingAdvancedCache(c, converter));
        this.converter = converter;
    }

    protected TypeConverterDelegatingAdvancedCache(AdvancedCache<K, V> cache, AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V> wrapper, TypeConverter converter) {
        super(cache, wrapper);
        this.converter = converter;
    }

    @Inject
    public void wireRealCache(ComponentRegistry registry, InternalEntryFactory entryFactory) {
        registry.wireDependencies(this.cache);
        this.entryFactory = entryFactory;
    }

    protected K boxKey(K key) {
        return (K)this.getConverter().boxKey(key);
    }

    protected V boxValue(V value) {
        return (V)this.getConverter().boxValue(value);
    }

    protected K unboxKey(K key) {
        return this.getConverter().unboxKey(key);
    }

    protected V unboxValue(V value) {
        return this.getConverter().unboxValue(value);
    }

    protected CacheEntry<K, V> convertEntry(K newKey, V newValue, CacheEntry<K, V> entry) {
        if (entry instanceof InternalCacheEntry) {
            return this.entryFactory.create(newKey, newValue, (InternalCacheEntry)entry);
        }
        return this.entryFactory.create(newKey, newValue, entry.getMetadata().version(), entry.getCreated(), entry.getLifespan(), entry.getLastUsed(), entry.getMaxIdle());
    }

    protected TypeConverter getConverter() {
        return this.converter;
    }

    private Function<? super K, ? extends V> convertFunction(Function<? super K, ? extends V> mappingFunction) {
        return k -> mappingFunction.apply((K)this.boxKey(k));
    }

    private BiFunction<? super K, ? super V, ? extends V> convertFunction(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (k, v) -> remappingFunction.apply((K)this.unboxKey(k), (V)this.unboxValue(v));
    }

    private Map<K, V> boxMap(Map<? extends K, ? extends V> map) {
        HashMap newMap = new HashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.boxKey(k), this.boxValue(v)));
        return newMap;
    }

    private Map<K, V> unboxMap(Map<K, V> map) {
        LinkedHashMap newMap = new LinkedHashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.unboxKey(k), this.unboxValue(v)));
        return newMap;
    }

    private Map<K, CacheEntry<K, V>> unboxEntryMap(Map<K, CacheEntry<K, V>> map) {
        HashMap entryMap = new HashMap(map.size());
        map.values().forEach((? super T v) -> {
            Object originalKey = v.getKey();
            Object boxedKey = this.boxKey(originalKey);
            Object originalValue = v.getValue();
            Object boxedValue = this.boxValue(originalValue);
            if (boxedKey != originalKey || boxedValue != originalValue) {
                entryMap.put(boxedKey, this.convertEntry(boxedKey, boxedValue, (CacheEntry<K, V>)v));
            }
        });
        return entryMap;
    }

    private Collection<K> convertKeys(Collection<? extends K> keys) {
        ArrayList list = new ArrayList(keys.size());
        keys.forEach((? super T k) -> list.add(this.boxKey(k)));
        return list;
    }

    private Set<?> convertKeys(Set<?> keys) {
        LinkedHashSet newKeys = new LinkedHashSet(keys.size());
        keys.forEach((? super T k) -> newKeys.add(this.boxKey(k)));
        return newKeys;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V returned = super.compute(this.boxKey(key), this.convertFunction(remappingFunction));
        return this.unboxValue(returned);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V returned = super.computeIfAbsent(this.boxKey(key), this.convertFunction(mappingFunction));
        return this.unboxValue(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V returned = super.computeIfPresent(this.boxKey(key), this.convertFunction(remappingFunction));
        return this.unboxValue(returned);
    }

    @Override
    public V put(K key, V value) {
        V returned = super.put(this.boxKey(key), this.boxValue(value));
        return this.unboxValue(returned);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V returned = super.put(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.unboxValue(returned);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        V returned = super.put(this.boxKey(key), this.boxValue(value), lifespan, unit);
        return this.unboxValue(returned);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        V returned = super.put(this.boxKey(key), this.boxValue(value), metadata);
        return this.unboxValue(returned);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V returned = super.putIfAbsent(this.boxKey(key), this.boxValue(value));
        return this.unboxValue(returned);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V returned = super.putIfAbsent(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.unboxValue(returned);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        V returned = super.putIfAbsent(this.boxKey(key), this.boxValue(value), lifespan, unit);
        return this.unboxValue(returned);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        V returned = super.putIfAbsent(this.boxKey(key), this.boxValue(value), metadata);
        return this.unboxValue(returned);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super.putAll(this.boxMap(map), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        super.putAll(this.boxMap(map), lifespan, unit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        super.putAll(this.boxMap(t));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return super.putAllAsync(this.boxMap(data));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAllAsync(this.boxMap(data), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return super.putAllAsync(this.boxMap(data), lifespan, unit);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return super.putAsync(this.boxKey(key), this.boxValue(value)).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAsync(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putAsync(this.boxKey(key), this.boxValue(value), lifespan, unit).thenApply(this::unboxValue);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        super.putForExternalRead(this.boxKey(key), this.boxValue(value));
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        super.putForExternalRead(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        super.putForExternalRead(this.boxKey(key), this.boxValue(value), lifespan, unit);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return super.putIfAbsentAsync(this.boxKey(key), this.boxValue(value)).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putIfAbsentAsync(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putIfAbsentAsync(this.boxKey(key), this.boxValue(value), lifespan, unit).thenApply(this::unboxValue);
    }

    @Override
    public V remove(Object key) {
        Object returned = super.remove(this.boxKey(key));
        return this.unboxValue(returned);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(this.boxKey(key), this.boxValue(value));
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return super.removeAsync(this.boxKey(key)).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return super.removeAsync(this.boxKey(key), this.boxValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return super.replace(this.boxKey(key), this.boxValue(oldValue), this.boxValue(newValue));
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return super.replace(this.boxKey(key), this.boxValue(oldValue), this.boxValue(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return super.replace(this.boxKey(key), this.boxValue(oldValue), this.boxValue(value), lifespan, unit);
    }

    @Override
    public V replace(K key, V value) {
        V returned = super.replace(this.boxKey(key), this.boxValue(value));
        return this.unboxValue(returned);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V returned = super.replace(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.unboxValue(returned);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        V returned = super.replace(this.boxKey(key), this.boxValue(value), lifespan, unit);
        return this.unboxValue(returned);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(oldValue), this.boxValue(newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(oldValue), this.boxValue(newValue), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(oldValue), this.boxValue(newValue), lifespan, unit);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(value)).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this::unboxValue);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.boxKey(key), this.boxValue(value), lifespan, unit).thenApply(this::unboxValue);
    }

    @Override
    protected void set(K key, V value) {
        super.set(this.boxKey(key), this.boxValue(value));
    }

    @Override
    public V get(Object key) {
        Object returned = super.get(this.boxKey(key));
        return this.unboxValue(returned);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return super.getAsync(this.boxKey(key)).thenApply(this::unboxValue);
    }

    @Override
    public void evict(K key) {
        super.evict(this.boxKey(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.boxKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(this.boxValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return super.replace(this.boxKey(key), this.boxValue(oldValue), this.boxValue(value), metadata);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        V returned = super.replace(this.boxKey(key), this.boxValue(value), metadata);
        return this.unboxValue(returned);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        super.putForExternalRead(this.boxKey(key), this.boxValue(value), metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return super.putAsync(this.boxKey(key), this.boxValue(value), metadata).thenApply(this::unboxValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        super.putAll(this.boxMap(map), metadata);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return super.lock(this.convertKeys(keys));
    }

    @Override
    public boolean lock(K ... keys) {
        Object[] newKeys = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            newKeys[i] = this.boxKey(keys[i]);
        }
        return super.lock(newKeys);
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        super.removeExpired(this.boxKey(key), this.boxValue(value), lifespan);
    }

    private <E extends Map.Entry<K, V>> CacheSet<E> cast(CacheSet set) {
        return set;
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cast(new TypeConverterEntrySet(this, this.cast(super.cacheEntrySet())));
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return new TypeConverterEntrySet(this, super.cacheEntrySet());
    }

    @Override
    public CacheSet<K> keySet() {
        return new TypeConverterKeySet(this, super.keySet());
    }

    @Override
    public CacheCollection<V> values() {
        return new TypeConverterValuesCollection(this, super.values());
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        Map returned = super.getGroup(groupName);
        return this.unboxMap(returned);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        Object boxedKey = this.boxKey(key);
        CacheEntry returned = super.getCacheEntry(boxedKey);
        if (returned != null) {
            Object originalValue = returned.getValue();
            Object unboxedValue = this.unboxValue(originalValue);
            if (boxedKey != key || unboxedValue != originalValue) {
                return this.convertEntry(key, unboxedValue, returned);
            }
        }
        return returned;
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        Map returned = super.getAll(this.convertKeys(keys));
        return this.unboxMap(returned);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        Map returned = super.getAllCacheEntries(this.convertKeys(keys));
        return this.unboxEntryMap(returned);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        super.forEach((k, v) -> {
            Object newK = this.unboxKey(k);
            Object newV = this.unboxValue(v);
            action.accept((K)newK, (V)newV);
        });
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V returned = super.getOrDefault(this.boxKey(key), defaultValue);
        if (returned == defaultValue) {
            return returned;
        }
        return this.unboxValue(returned);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object returned = super.merge(this.boxKey(key), value, (oldV, newV) -> {
            Object oldVUnboxed = this.unboxValue(oldV);
            return remappingFunction.apply((V)oldVUnboxed, (V)newV);
        });
        return (V)this.unboxValue(returned);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        super.replaceAll(this.convertFunction(function));
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        AdvancedCache returned = super.with(classLoader);
        if (returned != this && returned instanceof TypeConverterDelegatingAdvancedCache) {
            ((TypeConverterDelegatingAdvancedCache)returned).entryFactory = this.entryFactory;
        }
        return returned;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        AdvancedCache returned = super.withFlags(flags);
        if (returned != this && returned instanceof TypeConverterDelegatingAdvancedCache) {
            ((TypeConverterDelegatingAdvancedCache)returned).entryFactory = this.entryFactory;
        }
        return returned;
    }

    class TypeConverterValuesCollection
    extends AbstractCloseableIteratorCollection<V, K, V>
    implements CacheCollection<V> {
        private final CacheCollection<V> actualCollection;

        public TypeConverterValuesCollection(Cache<K, V> cache, CacheCollection<V> actualCollection) {
            super(cache);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<V> stream() {
            return this.actualCollection.stream().map((Function)TypeConverterDelegatingAdvancedCache.this.valueMapper);
        }

        @Override
        public CacheStream<V> parallelStream() {
            return this.actualCollection.parallelStream().map((Function)TypeConverterDelegatingAdvancedCache.this.valueMapper);
        }

        @Override
        public CloseableIterator<V> iterator() {
            return new CloseableIteratorMapper<Object, Object>((CloseableIterator<Object>)this.actualCollection.iterator(), TypeConverterDelegatingAdvancedCache.this::unboxValue);
        }

        @Override
        public CloseableSpliterator<V> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), TypeConverterDelegatingAdvancedCache.this::unboxValue);
        }

        @Override
        public boolean contains(Object o) {
            return this.actualCollection.contains(TypeConverterDelegatingAdvancedCache.this.boxValue(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.actualCollection.remove(TypeConverterDelegatingAdvancedCache.this.boxValue(o));
        }
    }

    class TypeConverterKeySet
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CacheSet<K> {
        private final CacheSet<K> actualCollection;

        public TypeConverterKeySet(Cache<K, V> cache, CacheSet<K> actualCollection) {
            super(cache);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<K> stream() {
            return this.actualCollection.stream().map((Function)TypeConverterDelegatingAdvancedCache.this.keyMapper);
        }

        @Override
        public CacheStream<K> parallelStream() {
            return this.actualCollection.parallelStream().map((Function)TypeConverterDelegatingAdvancedCache.this.keyMapper);
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new CloseableIteratorMapper<Object, Object>((CloseableIterator<Object>)this.actualCollection.iterator(), TypeConverterDelegatingAdvancedCache.this::unboxKey);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), TypeConverterDelegatingAdvancedCache.this::unboxKey);
        }

        @Override
        public boolean contains(Object o) {
            return this.actualCollection.contains(TypeConverterDelegatingAdvancedCache.this.boxKey(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.actualCollection.remove(TypeConverterDelegatingAdvancedCache.this.boxKey(o));
        }
    }

    private class TypeConverterEntrySet
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        private final CacheSet<CacheEntry<K, V>> actualCollection;

        public TypeConverterEntrySet(Cache<K, V> cache, CacheSet<CacheEntry<K, V>> actualCollection) {
            super(cache);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return this.actualCollection.stream().map((Function)TypeConverterDelegatingAdvancedCache.this.entryMapper);
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return this.actualCollection.parallelStream().map((Function)TypeConverterDelegatingAdvancedCache.this.entryMapper);
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new BaseTypeConverterInterceptor.TypeConverterIterator(this.actualCollection.iterator(), TypeConverterDelegatingAdvancedCache.this.getConverter(), TypeConverterDelegatingAdvancedCache.this.entryFactory);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), (Function<CacheEntry, CacheEntry> & InjectiveFunction)entry -> {
                Object key = entry.getKey();
                Object unboxedKey = TypeConverterDelegatingAdvancedCache.this.unboxKey(key);
                Object value = entry.getValue();
                Object unboxedValue = TypeConverterDelegatingAdvancedCache.this.unboxValue(value);
                if (unboxedKey != key || unboxedValue != value) {
                    return TypeConverterDelegatingAdvancedCache.this.convertEntry(unboxedKey, unboxedValue, entry);
                }
                return entry;
            });
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = this.toEntry(o);
            if (entry != null) {
                return this.actualCollection.contains(entry);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = this.toEntry(o);
            if (entry != null) {
                return this.actualCollection.remove(entry);
            }
            return false;
        }

        Map.Entry toEntry(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                Object newKey = TypeConverterDelegatingAdvancedCache.this.boxKey(key);
                Object value = entry.getValue();
                Object newValue = TypeConverterDelegatingAdvancedCache.this.boxValue(value);
                if (key != newKey || value != newValue) {
                    if (o instanceof CacheEntry) {
                        CacheEntry returned = (CacheEntry)o;
                        return TypeConverterDelegatingAdvancedCache.this.convertEntry(newKey, newValue, returned);
                    }
                    return TypeConverterDelegatingAdvancedCache.this.entryFactory.create(newKey, newValue, (Metadata)null);
                }
                return entry;
            }
            return null;
        }
    }
}

