/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetKeyValueCommand
extends AbstractDataCommand {
    public static final byte COMMAND_ID = 4;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetKeyValueCommand(Object key, long flagsBitSet) {
        super(key, flagsBitSet);
    }

    public GetKeyValueCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry.isRemoved()) {
            if (trace) {
                log.tracef("Entry has been deleted and is of type %s", (Object)entry.getClass().getSimpleName());
            }
            return null;
        }
        return entry.getValue();
    }

    @Override
    public byte getCommandId() {
        return 4;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public String toString() {
        return "GetKeyValueCommand {key=" + Util.toStr(this.key) + ", flags=" + this.printFlags() + "}";
    }
}

